/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PySuperClassAttributesCompletionContributor
extends CompletionContributor {
    public PySuperClassAttributesCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParents(new Class[]{PyReferenceExpression.class, PyExpressionStatement.class, PyStatementList.class, PyClass.class}), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PySuperClassAttributesCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PySuperClassAttributesCompletionContributor$1", "addCompletions"));
                }
                PsiElement position = parameters.getOriginalPosition();
                PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)position, PyClass.class);
                if (containingClass == null) {
                    return;
                }
                for (PyTargetExpression expr : PySuperClassAttributesCompletionContributor.getSuperClassAttributes(containingClass)) {
                    result.addElement((LookupElement)LookupElementBuilder.create((Object)expr, (String)(expr.getName() + " = ")));
                }
            }
        });
    }

    public static List<PyTargetExpression> getSuperClassAttributes(@NotNull PyClass cls) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/codeInsight/completion/PySuperClassAttributesCompletionContributor", "getSuperClassAttributes"));
        }
        ArrayList attrs = Lists.newArrayList();
        ArrayList seenNames = Lists.newArrayList();
        for (PyTargetExpression expr : cls.getClassAttributes()) {
            seenNames.add(expr.getName());
        }
        for (PyClass ancestor : cls.getAncestorClasses()) {
            for (PyTargetExpression expr : ancestor.getClassAttributes()) {
                if (seenNames.contains(expr.getName())) continue;
                seenNames.add(expr.getName());
                attrs.add(expr);
            }
        }
        return attrs;
    }
}

