/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.PyUnindentingInsertHandler;
import com.jetbrains.python.codeInsight.completion.PythonLookupElement;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyWithItem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyKeywordCompletionContributor
extends CompletionContributor {
    private static ElementPattern NOT_PARAMETER_OR_DEFAULT_VALUE = new FilterPattern((ElementFilter)new NotParameterOrDefaultValue());
    private static final PsiElementPattern.Capture<PsiElement> IN_COMMENT = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(PsiComment.class);
    private static final PsiElementPattern.Capture<PsiElement> IN_STRING_LITERAL = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(PyStringLiteralExpression.class)).andNot((ElementPattern)PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile(PyDocstringFile.class)));
    private static final ElementPattern<PsiElement> IN_FUNCTION_HEADER = StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(PyFunction.class)).andNot((ElementPattern)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(PyStatementList.class), (ElementPattern)PlatformPatterns.psiElement(PyFunction.class))), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(PyClass.class)).andNot((ElementPattern)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(PyStatementList.class), (ElementPattern)PlatformPatterns.psiElement(PyClass.class)))});
    public static final PsiElementPattern.Capture<PsiElement> AFTER_QUALIFIER = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText(".")).inside(PyReferenceExpression.class));
    public static final FilterPattern FIRST_ON_LINE = new FilterPattern((ElementFilter)new StartOfLineFilter());
    private static final PsiElementPattern.Capture<PsiElement> IN_IMPORT_AFTER_REF = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType((IElementType)PyTokenTypes.IDENTIFIER)).inside(PyReferenceExpression.class)).inside(PyImportElement.class));
    public static final PsiElementPattern.Capture<PsiElement> IN_FROM_IMPORT_AFTER_REF = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType((IElementType)PyTokenTypes.IDENTIFIER)).inside(PyReferenceExpression.class), PlatformPatterns.psiElement().withElementType((IElementType)PyTokenTypes.DOT)}))).inside(PyFromImportStatement.class);
    public static final ElementPattern<PsiElement> IN_WITH_AFTER_REF = PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PyWithItem.class).with((PatternCondition)new PatternCondition<PyWithItem>("withoutAsKeyword"){

        public boolean accepts(@NotNull PyWithItem item, ProcessingContext context) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$1", "accepts"));
            }
            return item.getNode().findChildByType((IElementType)PyTokenTypes.AS_KEYWORD) == null;
        }
    })));
    private static final PsiElementPattern.Capture<PsiElement> IN_EXCEPT_AFTER_REF = (PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType((IElementType)PyTokenTypes.IDENTIFIER)).inside(PyReferenceExpression.class)).inside(PyExceptPart.class));
    private static final PsiElementPattern.Capture<PsiElement> IN_COND_STMT = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PyStatementList.class).inside((ElementPattern)PlatformPatterns.psiElement(PyConditionalStatementPart.class)));
    private static final PsiElementPattern.Capture<PsiElement> IN_IF_BODY = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PyStatementList.class).inside((ElementPattern)PlatformPatterns.psiElement(PyIfPart.class)));
    private static final PsiElementPattern.Capture<PsiElement> IN_LOOP = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(PyLoopStatement.class), StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(PyFunction.class), PlatformPatterns.psiElement(PyClass.class)}));
    private static final PsiElementPattern.Capture<PsiElement> BEFORE_COND = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(PyConditionalStatementPart.class)).andOr(new ElementPattern[]{PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("if")), PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("elif")), PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("while"))});
    private static final PsiElementPattern.Capture<PsiElement> IN_IMPORT_STMT = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(PyImportStatement.class), PlatformPatterns.psiElement(PyFromImportStatement.class)}));
    private static final PsiElementPattern.Capture<PsiElement> IN_PARAM_LIST = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(PyParameterList.class);
    private static final PsiElementPattern.Capture<PsiElement> IN_ARG_LIST = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(PyArgumentList.class);
    private static final PsiElementPattern.Capture<PsiElement> IN_DEF_BODY = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(PyFunction.class), (ElementPattern)PlatformPatterns.psiElement(PyClass.class));
    private static final PsiElementPattern.Capture<PsiElement> IN_TRY_BODY = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PyStatementList.class).inside((ElementPattern)PlatformPatterns.psiElement(PyTryPart.class)));
    private static final PsiElementPattern.Capture<PsiElement> IN_EXCEPT_BODY = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PyStatementList.class).inside((ElementPattern)PlatformPatterns.psiElement(PyExceptPart.class)));
    private static final PsiElementPattern.Capture<PsiElement> IN_ELSE_BODY_OF_TRY = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PyStatementList.class).inside((ElementPattern)PlatformPatterns.psiElement(PyElsePart.class).inside(PyTryExceptStatement.class)));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_IF = PyKeywordCompletionContributor.afterStatement((PsiElementPattern.Capture)PlatformPatterns.psiElement(PyIfStatement.class).withLastChild((ElementPattern)PlatformPatterns.psiElement(PyIfPart.class)));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_TRY = PyKeywordCompletionContributor.afterStatement(PlatformPatterns.psiElement(PyTryExceptStatement.class));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_LOOP_NO_ELSE = PyKeywordCompletionContributor.afterStatement((PsiElementPattern.Capture)PlatformPatterns.psiElement(PyLoopStatement.class).withLastChild((ElementPattern)StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement(PyElsePart.class))));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_COND_STMT_NO_ELSE = PyKeywordCompletionContributor.afterStatement((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withChild((ElementPattern)PlatformPatterns.psiElement(PyConditionalStatementPart.class))).withLastChild((ElementPattern)StandardPatterns.not((ElementPattern)PlatformPatterns.psiElement(PyElsePart.class))));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_EXCEPT = PyKeywordCompletionContributor.afterStatement((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLastChild((ElementPattern)PlatformPatterns.psiElement(PyExceptPart.class)));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_FINALLY = PyKeywordCompletionContributor.afterStatement((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLastChild((ElementPattern)PlatformPatterns.psiElement(PyFinallyPart.class)));
    private static final PsiElementPattern.Capture<PsiElement> AFTER_ELSE = PyKeywordCompletionContributor.afterStatement((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLastChild((ElementPattern)PlatformPatterns.psiElement(PyElsePart.class)));
    private static final PsiElementPattern.Capture<PsiElement> IN_FINALLY_NO_LOOP = (PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(PyFinallyPart.class), (ElementPattern)PlatformPatterns.psiElement(PyLoopStatement.class));
    private static final FilterPattern IN_BEGIN_STMT = new FilterPattern((ElementFilter)new StatementFitFilter());
    private static final FilterPattern PY3K = new FilterPattern((ElementFilter)new Py3kFilter());

    private static <T extends PsiElement> PsiElementPattern.Capture<PsiElement> afterStatement(PsiElementPattern.Capture<T> statementPattern) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement().atStartOf((ElementPattern)PlatformPatterns.psiElement(PyExpressionStatement.class).afterSiblingSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), statementPattern));
    }

    private static void putKeywords(CompletionResultSet result, TailType tail, String ... words) {
        if (words == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "words", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor", "putKeywords"));
        }
        for (String s : words) {
            result.addElement(TailTypeDecorator.withTail(new PythonLookupElement(s, true, null), tail));
        }
    }

    private static void putKeyword(@NotNull @NonNls String keyword, InsertHandler<PythonLookupElement> handler, TailType tail, CompletionResultSet result) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor", "putKeyword"));
        }
        PythonLookupElement lookupElement = new PythonLookupElement(keyword, true, null);
        lookupElement.setHandler(handler);
        result.addElement(TailTypeDecorator.withTail(lookupElement, tail));
    }

    private void addPreColonStatements() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)FIRST_ON_LINE)).andNot(IN_IMPORT_STMT)).andNot(IN_PARAM_LIST)).andNot(IN_ARG_LIST)).andNot(BEFORE_COND)).andNot(AFTER_QUALIFIER)).andNot(IN_STRING_LITERAL), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$2", "addCompletions"));
                }
                PyKeywordCompletionContributor.putKeywords(result, TailType.NONE, new String[]{"def", "class", "for", "if", "while", "with"});
                PyKeywordCompletionContributor.putKeywords(result, TailType.CASE_COLON, new String[]{"try"});
            }
        });
    }

    private void addStatements() {
        PsiElementPattern.Capture inStatement = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)IN_BEGIN_STMT)).andNot(IN_IMPORT_STMT)).andNot(IN_PARAM_LIST)).andNot(IN_ARG_LIST)).andNot(BEFORE_COND)).andNot(AFTER_QUALIFIER);
        this.extend(CompletionType.BASIC, (ElementPattern)inStatement, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$3", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$3", "addCompletions"));
                }
                PyKeywordCompletionContributor.putKeywords(result, TailType.SPACE, new String[]{"assert", "del", "exec", "from", "import", "raise"});
                PyKeywordCompletionContributor.putKeywords(result, TailType.NONE, new String[]{"pass"});
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)inStatement.andNot((ElementPattern)PY3K), new PyKeywordCompletionProvider(TailType.SPACE, new String[]{"print"}));
    }

    private void addBreak() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)IN_BEGIN_STMT)).andNot(AFTER_QUALIFIER)).andNot(IN_PARAM_LIST)).andNot(IN_ARG_LIST)).and(IN_LOOP), new PyKeywordCompletionProvider(TailType.NONE, new String[]{"break"}));
    }

    private void addContinue() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)IN_BEGIN_STMT)).andNot(AFTER_QUALIFIER)).andNot(IN_PARAM_LIST)).andNot(IN_ARG_LIST)).andNot(IN_FINALLY_NO_LOOP)).and(IN_LOOP), new PyKeywordCompletionProvider(TailType.NONE, new String[]{"continue"}));
    }

    private void addWithinFuncs() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and(IN_DEF_BODY)).and((ElementPattern)IN_BEGIN_STMT)).andNot(AFTER_QUALIFIER), new PyKeywordCompletionProvider(new String[]{"global", "return", "yield"}));
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and(IN_DEF_BODY)).and((ElementPattern)IN_BEGIN_STMT)).and((ElementPattern)PY3K)).andNot(AFTER_QUALIFIER), new PyKeywordCompletionProvider(new String[]{"nonlocal"}));
    }

    private void addWithinIf() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)FIRST_ON_LINE)).andOr(new ElementPattern[]{IN_IF_BODY, AFTER_IF})).andNot(AFTER_QUALIFIER)).andNot(IN_STRING_LITERAL), new PyKeywordCompletionProvider(TailType.NONE, PyUnindentingInsertHandler.INSTANCE, new String[]{"elif"}));
    }

    private void addWithinTry() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)FIRST_ON_LINE)).andOr(new ElementPattern[]{IN_TRY_BODY, IN_EXCEPT_BODY, AFTER_TRY, IN_ELSE_BODY_OF_TRY})).andNot(AFTER_QUALIFIER)).andNot(IN_STRING_LITERAL)).andNot(AFTER_FINALLY), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$4", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$4", "addCompletions"));
                }
                PyKeywordCompletionContributor.putKeyword("finally", (InsertHandler<PythonLookupElement>)PyUnindentingInsertHandler.INSTANCE, TailType.CASE_COLON, result);
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)FIRST_ON_LINE)).andOr(new ElementPattern[]{IN_TRY_BODY, IN_EXCEPT_BODY, AFTER_TRY, IN_ELSE_BODY_OF_TRY})).andNot(AFTER_QUALIFIER)).andNot(IN_STRING_LITERAL)).andNot(AFTER_FINALLY)).andNot(AFTER_ELSE), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$5", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$5", "addCompletions"));
                }
                PyKeywordCompletionContributor.putKeyword("except", (InsertHandler<PythonLookupElement>)PyUnindentingInsertHandler.INSTANCE, TailType.NONE, result);
            }
        });
    }

    private void addElse() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)FIRST_ON_LINE)).andOr(new ElementPattern[]{IN_COND_STMT, IN_EXCEPT_BODY, AFTER_COND_STMT_NO_ELSE, AFTER_LOOP_NO_ELSE, AFTER_EXCEPT})).andNot(AFTER_QUALIFIER)).andNot(IN_STRING_LITERAL), new PyKeywordCompletionProvider(TailType.CASE_COLON, PyUnindentingInsertHandler.INSTANCE, new String[]{"else"}));
    }

    private void addInfixOperators() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).andNot(IN_COMMENT)).andNot(BEFORE_COND)).andNot(IN_IMPORT_STMT)).andNot(IN_PARAM_LIST)).andNot(AFTER_QUALIFIER)).andNot(IN_STRING_LITERAL)).and((ElementPattern)IN_BEGIN_STMT), new PyKeywordCompletionProvider(new String[]{"and", "or", "is", "in"}));
    }

    private void addNot() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).andNot(IN_COMMENT)).andNot(IN_IMPORT_STMT)).andNot(IN_PARAM_LIST)).andNot(IN_FUNCTION_HEADER)).andNot(AFTER_QUALIFIER)).andNot(IN_STRING_LITERAL), new PyKeywordCompletionProvider(new String[]{"not", "lambda"}));
    }

    private void addPy3kLiterals() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)PY3K)).andNot(IN_COMMENT)).andNot(IN_IMPORT_STMT)).and(NOT_PARAMETER_OR_DEFAULT_VALUE)).andNot(AFTER_QUALIFIER)).andNot(IN_FUNCTION_HEADER), new PyKeywordCompletionProvider(TailType.NONE, new String[]{"True", "False", "None"}));
    }

    private void addAs() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).andOr(new ElementPattern[]{IN_IMPORT_AFTER_REF, IN_WITH_AFTER_REF, IN_EXCEPT_AFTER_REF})).andNot(AFTER_QUALIFIER), new PyKeywordCompletionProvider(new String[]{"as"}));
    }

    private void addImportInFrom() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and(IN_FROM_IMPORT_AFTER_REF)).andNot(AFTER_QUALIFIER), new PyKeywordCompletionProvider(new String[]{"import"}));
    }

    private void addExprElse() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespace(), (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PyConditionalExpression.class))).and((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"if"}))), new PyKeywordCompletionProvider(TailType.SPACE, new String[]{"else"}));
    }

    private void addRaiseFrom() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)PY3K)).afterLeaf((ElementPattern)PlatformPatterns.psiElement().inside(PyRaiseStatement.class)), new PyKeywordCompletionProvider(new String[]{"from"}));
    }

    private void addYieldExpression() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).andOr(new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(PyAssignmentStatement.class), (ElementPattern)PlatformPatterns.psiElement(PyTargetExpression.class))).afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType((IElementType)PyTokenTypes.EQ)), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside(false, (ElementPattern)PlatformPatterns.psiElement(PyAugAssignmentStatement.class), (ElementPattern)PlatformPatterns.psiElement(PyTargetExpression.class))).afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType(PyTokenTypes.AUG_ASSIGN_OPERATIONS)), PlatformPatterns.psiElement().inside(true, (ElementPattern)PlatformPatterns.psiElement(PyParenthesizedExpression.class))}), new PyKeywordCompletionProvider(new String[]{"yield"}));
    }

    private void addYieldFrom() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)PY3K)).afterLeaf((ElementPattern)PlatformPatterns.psiElement().withElementType((IElementType)PyTokenTypes.YIELD_KEYWORD)), new PyKeywordCompletionProvider(new String[]{"from"}));
    }

    public PyKeywordCompletionContributor() {
        this.addStatements();
        this.addPreColonStatements();
        this.addWithinIf();
        this.addElse();
        this.addBreak();
        this.addContinue();
        this.addWithinFuncs();
        this.addWithinTry();
        this.addInfixOperators();
        this.addNot();
        this.addAs();
        this.addImportInFrom();
        this.addPy3kLiterals();
        this.addExprElse();
        this.addRaiseFrom();
        this.addYieldExpression();
        this.addYieldFrom();
        this.addForToComprehensions();
        this.addInToFor();
    }

    private void addForToComprehensions() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).inside((ElementPattern)PlatformPatterns.psiElement(PySequenceExpression.class))).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement((IElementType)PyTokenTypes.LBRACE), PlatformPatterns.psiElement((IElementType)PyTokenTypes.LBRACKET), PlatformPatterns.psiElement((IElementType)PyTokenTypes.LPAR)}))), new PyKeywordCompletionProvider(new String[]{"for"}));
    }

    private void addInToFor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)PythonLanguage.getInstance())).and((ElementPattern)PlatformPatterns.psiElement())).afterLeaf((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"for"})), new PyKeywordCompletionProvider(new String[]{"in"}));
    }

    private static class PyKeywordCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private final String[] myKeywords;
        private final TailType myTailType;
        private final InsertHandler<PythonLookupElement> myInsertHandler;

        private PyKeywordCompletionProvider(String ... keywords) {
            this(TailType.SPACE, keywords);
        }

        private PyKeywordCompletionProvider(TailType tailType, String ... keywords) {
            this(tailType, (InsertHandler<PythonLookupElement>)null, keywords);
        }

        private PyKeywordCompletionProvider(TailType tailType, @Nullable InsertHandler<PythonLookupElement> insertHandler, String ... keywords) {
            this.myKeywords = keywords;
            this.myTailType = tailType;
            this.myInsertHandler = insertHandler;
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$PyKeywordCompletionProvider", "addCompletions"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PyKeywordCompletionContributor$PyKeywordCompletionProvider", "addCompletions"));
            }
            for (String s : this.myKeywords) {
                PythonLookupElement element = new PythonLookupElement(s, true, null);
                if (this.myInsertHandler != null) {
                    element.setHandler(this.myInsertHandler);
                }
                result.addElement(TailTypeDecorator.withTail(element, this.myTailType));
            }
        }
    }

    private static class NotParameterOrDefaultValue
    implements ElementFilter {
        private NotParameterOrDefaultValue() {
        }

        public boolean isAcceptable(Object element, PsiElement context) {
            if (!(element instanceof PsiElement)) {
                return false;
            }
            PsiElement psiElement = (PsiElement)element;
            PsiElement definition = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyDocStringOwner.class, (boolean)false, (Class[])new Class[]{PyStatementList.class});
            if (definition != null) {
                PyExpression defaultValue;
                if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyParameterList.class) == null) {
                    return true;
                }
                PyParameter param = (PyParameter)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PyParameter.class);
                return param != null && (defaultValue = param.getDefaultValue()) != null && PsiTreeUtil.isAncestor((PsiElement)defaultValue, (PsiElement)psiElement, (boolean)false);
            }
            return true;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }

    private static class Py3kFilter
    implements ElementFilter {
        private Py3kFilter() {
        }

        public boolean isAcceptable(Object element, PsiElement context) {
            if (!(element instanceof PsiElement)) {
                return false;
            }
            PsiFile containingFile = ((PsiElement)element).getContainingFile();
            return containingFile instanceof PyFile && ((PyFile)containingFile).getLanguageLevel().isPy3K();
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }

    private static class StartOfLineFilter
    implements ElementFilter {
        private StartOfLineFilter() {
        }

        public boolean isAcceptable(Object what, PsiElement context) {
            String indentCharacters;
            if (!(what instanceof PsiElement)) {
                return false;
            }
            PsiElement p = (PsiElement)what;
            if (p instanceof PsiComment) {
                return false;
            }
            int point = p.getTextOffset();
            PsiDocumentManager docMgr = PsiDocumentManager.getInstance((Project)p.getProject());
            PsiFile file = p.getContainingFile().getOriginalFile();
            Document doc = docMgr.getDocument(file);
            String string = indentCharacters = file.getViewProvider() instanceof InjectedFileViewProvider ? " \t>" : " \t";
            if (doc != null) {
                char c;
                CharSequence chs = doc.getCharsSequence();
                do {
                    if (--point < 0) {
                        return true;
                    }
                    c = chs.charAt(point);
                    if (c != '\n') continue;
                    return true;
                } while (indentCharacters.indexOf(c) >= 0);
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }

    private static class StatementFitFilter
    implements ElementFilter {
        public boolean isAcceptable(Object element, PsiElement context) {
            if (element instanceof PsiElement) {
                ASTNode ctxNode = context.getNode();
                if (ctxNode != null && PyTokenTypes.STRING_NODES.contains(ctxNode.getElementType())) {
                    return false;
                }
                PsiElement p = (PsiElement)element;
                int firstOffset = p.getTextRange().getStartOffset();
                while (true) {
                    if (p == null) {
                        return false;
                    }
                    if (p.getTextRange().getStartOffset() != firstOffset) {
                        return false;
                    }
                    if (p instanceof PyStatement) break;
                    p = p.getParent();
                }
                PsiElement container = p.getParent();
                if (!(container instanceof PyElement)) {
                    return true;
                }
                if (container instanceof PyStatementList || container instanceof PsiFile) {
                    PsiElement prev = p.getPrevSibling();
                    while (prev instanceof PsiWhiteSpace) {
                        prev = prev.getPrevSibling();
                    }
                    if (prev == null) {
                        return true;
                    }
                    if (prev instanceof PyStatement || prev instanceof PsiComment) {
                        PsiDocumentManager docMgr;
                        Document doc;
                        return !(prev.getLastChild() instanceof PsiErrorElement) || (doc = (docMgr = PsiDocumentManager.getInstance((Project)p.getProject())).getDocument(p.getContainingFile().getOriginalFile())) == null || doc.getLineNumber(prev.getTextRange().getEndOffset()) != doc.getLineNumber(firstOffset);
                    }
                }
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }
}

