/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyDocstringCompletionContributor
extends CompletionContributor {
    public PyDocstringCompletionContributor() {
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().inside(PyStringLiteralExpression.class), PlatformPatterns.psiComment()}), new IdentifierCompletionProvider());
    }

    private static String getPrefix(int offset, PsiFile file) {
        if (offset > 0) {
            --offset;
        }
        String text = file.getText();
        StringBuilder prefixBuilder = new StringBuilder();
        while (offset > 0 && Character.isLetterOrDigit(text.charAt(offset))) {
            prefixBuilder.insert(0, text.charAt(offset));
            --offset;
        }
        return prefixBuilder.toString();
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/python/codeInsight/completion/PyDocstringCompletionContributor", "invokeAutoPopup"));
        }
        return false;
    }

    private static class IdentifierCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private IdentifierCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PyDocstringCompletionContributor$IdentifierCompletionProvider", "addCompletions"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PyDocstringCompletionContributor$IdentifierCompletionProvider", "addCompletions"));
            }
            if (parameters.isAutoPopup()) {
                return;
            }
            PsiElement element = parameters.getOriginalPosition();
            if (element == null) {
                return;
            }
            PsiFile file = element.getContainingFile();
            if (file.findReferenceAt(parameters.getOffset()) != null) {
                return;
            }
            PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PyDocStringOwner.class);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            if (module != null) {
                result = result.withPrefixMatcher(PyDocstringCompletionContributor.getPrefix(parameters.getOffset(), file));
                Collection<String> identifiers = PyRefactoringUtil.collectUsedNames((PsiElement)docStringOwner);
                for (String identifier : identifiers) {
                    result.addElement(LookupElementBuilder.create((String)identifier).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
                }
                Collection<String> fileIdentifiers = PyRefactoringUtil.collectUsedNames((PsiElement)parameters.getOriginalFile());
                for (String identifier : fileIdentifiers) {
                    result.addElement(LookupElementBuilder.create((String)identifier).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
                }
            }
        }
    }
}

