/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class PyDictKeyNamesCompletionContributor
extends CompletionContributor {
    public PyDictKeyNamesCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside(PySubscriptionExpression.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                PsiElement resolvedElement;
                PsiReference reference;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor$1", "addCompletions"));
                }
                PsiElement original = parameters.getOriginalPosition();
                int offset = parameters.getOffset();
                if (original == null) {
                    return;
                }
                CompletionResultSet dictCompletion = PyDictKeyNamesCompletionContributor.createResult(original, result, offset);
                PySubscriptionExpression subscription = (PySubscriptionExpression)PsiTreeUtil.getParentOfType((PsiElement)original, PySubscriptionExpression.class);
                if (subscription == null) {
                    return;
                }
                PyExpression operand = subscription.getOperand();
                if (operand != null && (reference = operand.getReference()) != null && (resolvedElement = reference.resolve()) instanceof PyTargetExpression) {
                    PyCallExpression dictConstructor;
                    PyDictLiteralExpression dict = (PyDictLiteralExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)resolvedElement, PyDictLiteralExpression.class);
                    if (dict != null) {
                        PyDictKeyNamesCompletionContributor.addDictLiteralKeys(dict, dictCompletion);
                        PsiFile file = parameters.getOriginalFile();
                        PyDictKeyNamesCompletionContributor.addAdditionalKeys(file, (PsiElement)operand, dictCompletion);
                    }
                    if ((dictConstructor = (PyCallExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)resolvedElement, PyCallExpression.class)) != null) {
                        PyDictKeyNamesCompletionContributor.addDictConstructorKeys(dictConstructor, dictCompletion);
                        PsiFile file = parameters.getOriginalFile();
                        PyDictKeyNamesCompletionContributor.addAdditionalKeys(file, (PsiElement)operand, dictCompletion);
                    }
                }
            }
        });
    }

    private static CompletionResultSet createResult(@NotNull PsiElement original, @NotNull CompletionResultSet result, int offset) {
        ASTNode prevNode;
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor", "createResult"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PyDictKeyNamesCompletionContributor", "createResult"));
        }
        PyStringLiteralExpression prevElement = (PyStringLiteralExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)original, PyStringLiteralExpression.class);
        if (prevElement != null && (prevNode = prevElement.getNode()) != null && prevNode.getElementType() != PyTokenTypes.LBRACKET) {
            return result.withPrefixMatcher(PyDictKeyNamesCompletionContributor.findPrefix(prevElement, offset));
        }
        PsiElement parentElement = original.getParent();
        if (parentElement != null && parentElement instanceof PyStringLiteralExpression) {
            return result.withPrefixMatcher(PyDictKeyNamesCompletionContributor.findPrefix((PyElement)parentElement, offset));
        }
        PyNumericLiteralExpression number = (PyNumericLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)original.getContainingFile(), (int)(offset - 1), PyNumericLiteralExpression.class, (boolean)false);
        if (number != null) {
            return result.withPrefixMatcher(PyDictKeyNamesCompletionContributor.findPrefix(number, offset));
        }
        return result;
    }

    private static String findPrefix(PyElement element, int offset) {
        return TextRange.create((int)element.getTextRange().getStartOffset(), (int)offset).substring(element.getContainingFile().getText());
    }

    private static void addDictConstructorKeys(PyCallExpression dictConstructor, CompletionResultSet result) {
        TypeEvalContext context;
        PyType type;
        PyExpression callee = dictConstructor.getCallee();
        if (callee == null) {
            return;
        }
        String name = callee.getText();
        if ("dict".equals(name) && (type = (context = TypeEvalContext.userInitiated(callee.getProject(), callee.getContainingFile())).getType(dictConstructor)) != null && type.isBuiltin()) {
            PyExpression[] argumentList;
            PyArgumentList list = dictConstructor.getArgumentList();
            if (list == null) {
                return;
            }
            for (PyExpression argument : argumentList = list.getArguments()) {
                if (!(argument instanceof PyKeywordArgument)) continue;
                result.addElement((LookupElement)PyDictKeyNamesCompletionContributor.createElement("'" + ((PyKeywordArgument)argument).getKeyword() + "'"));
            }
        }
    }

    private static void addAdditionalKeys(PsiFile file, PsiElement operand, CompletionResultSet result) {
        PySubscriptionExpression[] subscriptionExpressions;
        for (PySubscriptionExpression expr : subscriptionExpressions = (PySubscriptionExpression[])PyUtil.getAllChildrenOfType((PsiElement)file, PySubscriptionExpression.class)) {
            PyExpression key;
            PsiElement parent;
            if (!expr.getOperand().getText().equals(operand.getText()) || !((parent = expr.getParent()) instanceof PyAssignmentStatement) || !expr.equals(((PyAssignmentStatement)parent).getLeftHandSideExpression()) || (key = expr.getIndexExpression()) == null) continue;
            boolean addHandler = PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)key.getTextRange().getStartOffset(), (int)key.getTextRange().getEndOffset(), PyStringLiteralExpression.class) != null;
            result.addElement((LookupElement)PyDictKeyNamesCompletionContributor.createElement(key.getText(), addHandler));
        }
    }

    private static void addDictLiteralKeys(PyDictLiteralExpression dict, CompletionResultSet result) {
        PyKeyValueExpression[] keyValues;
        for (PyKeyValueExpression expression : keyValues = dict.getElements()) {
            boolean addHandler = PsiTreeUtil.findElementOfClassAtRange((PsiFile)dict.getContainingFile(), (int)expression.getTextRange().getStartOffset(), (int)expression.getTextRange().getEndOffset(), PyStringLiteralExpression.class) != null;
            result.addElement((LookupElement)PyDictKeyNamesCompletionContributor.createElement(expression.getKey().getText(), addHandler));
        }
    }

    private static LookupElementBuilder createElement(String key) {
        return PyDictKeyNamesCompletionContributor.createElement(key, true);
    }

    private static LookupElementBuilder createElement(String key, boolean addHandler) {
        LookupElementBuilder item = LookupElementBuilder.create((String)key).withTypeText("dict key").withIcon(PlatformIcons.PARAMETER_ICON);
        if (addHandler) {
            item = item.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    PyStringLiteralExpression str = (PyStringLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PyStringLiteralExpression.class, (boolean)false);
                    if (str != null) {
                        boolean isDictKeys;
                        boolean bl = isDictKeys = PsiTreeUtil.getParentOfType((PsiElement)str, PySubscriptionExpression.class) != null;
                        if (isDictKeys) {
                            boolean badQuoting;
                            int off = context.getStartOffset() + str.getTextLength();
                            PsiElement element = context.getFile().findElementAt(off);
                            boolean atRBrace = element == null || element.getNode().getElementType() == PyTokenTypes.RBRACKET;
                            boolean bl2 = badQuoting = !(StringUtil.startsWithChar((CharSequence)str.getText(), (char)'\'') && StringUtil.endsWithChar((CharSequence)str.getText(), (char)'\'') || StringUtil.startsWithChar((CharSequence)str.getText(), (char)'\"') && StringUtil.endsWithChar((CharSequence)str.getText(), (char)'\"'));
                            if (badQuoting || !atRBrace) {
                                Document document = context.getEditor().getDocument();
                                int offset = context.getTailOffset();
                                document.deleteString(offset - 1, offset);
                            }
                        }
                    }
                }
            });
        }
        return item;
    }
}

