/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyCompletionConfidence
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldFocusLookup(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PyCompletionConfidence", "shouldFocusLookup"));
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/completion/PyCompletionConfidence", "shouldFocusLookup"));
        }
        return threeState;
    }

    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/jetbrains/python/codeInsight/completion/PyCompletionConfidence", "shouldSkipAutopopup"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/python/codeInsight/completion/PyCompletionConfidence", "shouldSkipAutopopup"));
        }
        ASTNode node = contextElement.getNode();
        if (node != null) {
            PsiElement parent;
            if (node.getElementType() == PyTokenTypes.FLOAT_LITERAL) {
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/completion/PyCompletionConfidence", "shouldSkipAutopopup"));
                }
                return threeState;
            }
            if (PyTokenTypes.STRING_NODES.contains(node.getElementType()) && (parent = contextElement.getParent()) instanceof PyStringLiteralExpression) {
                List<TextRange> ranges = ((PyStringLiteralExpression)parent).getStringValueTextRanges();
                int relativeOffset = offset - parent.getTextRange().getStartOffset();
                if (ranges.size() > 0 && relativeOffset < ranges.get(0).getStartOffset()) {
                    ThreeState threeState = ThreeState.YES;
                    if (threeState == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/completion/PyCompletionConfidence", "shouldSkipAutopopup"));
                    }
                    return threeState;
                }
            }
        }
        ThreeState threeState = super.shouldSkipAutopopup(contextElement, psiFile, offset);
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/completion/PyCompletionConfidence", "shouldSkipAutopopup"));
        }
        return threeState;
    }
}

