/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.completion.PyFunctionInsertHandler;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.PythonReferenceImporter;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import com.jetbrains.python.psi.types.PyModuleType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PyClassNameCompletionContributor
extends CompletionContributor {
    private static Condition<PsiElement> IS_TOPLEVEL = new Condition<PsiElement>(){

        public boolean value(PsiElement element) {
            return PyUtil.isTopLevel(element);
        }
    };
    private static final InsertHandler<LookupElement> IMPORTING_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            PyClassNameCompletionContributor.addImportForLookupElement(context, item, context.getTailOffset() - 1);
        }
    };
    private static final InsertHandler<LookupElement> FUNCTION_INSERT_HANDLER = new PyFunctionInsertHandler(){

        @Override
        public void handleInsert(InsertionContext context, LookupElement item) {
            int tailOffset = context.getTailOffset() - 1;
            super.handleInsert(context, item);
            context.commitDocument();
            PyClassNameCompletionContributor.addImportForLookupElement(context, item, tailOffset);
        }
    };
    private static final InsertHandler<LookupElement> STRING_LITERAL_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(InsertionContext context, LookupElement item) {
            PsiElement element = item.getPsiElement();
            if (element instanceof PyQualifiedNameOwner) {
                String qName = ((PyQualifiedNameOwner)element).getQualifiedName();
                String name = ((PyQualifiedNameOwner)element).getName();
                if (qName != null && name != null) {
                    String qNamePrefix = qName.substring(0, qName.length() - name.length());
                    context.getDocument().insertString(context.getStartOffset(), (CharSequence)qNamePrefix);
                }
            }
        }
    };

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters.isExtendedCompletion()) {
            String prefix;
            PsiElement element = parameters.getPosition();
            PsiElement parent = element.getParent();
            if (parent instanceof PyReferenceExpression && ((PyReferenceExpression)parent).isQualified()) {
                return;
            }
            if (parent instanceof PyStringLiteralExpression && (prefix = parent.getText().substring(0, parameters.getOffset() - parent.getTextRange().getStartOffset())).contains(".")) {
                return;
            }
            FileViewProvider provider = element.getContainingFile().getViewProvider();
            if (provider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class) != null) {
                return;
            }
            PsiFile originalFile = parameters.getOriginalFile();
            PyClassNameCompletionContributor.addVariantsFromIndex(result, originalFile, PyClassNameIndex.KEY, parent instanceof PyStringLiteralExpression ? STRING_LITERAL_INSERT_HANDLER : IMPORTING_INSERT_HANDLER, Conditions.alwaysTrue(), PyClass.class);
            PyClassNameCompletionContributor.addVariantsFromIndex(result, originalFile, PyFunctionNameIndex.KEY, PyClassNameCompletionContributor.getFunctionInsertHandler(parent), IS_TOPLEVEL, PyFunction.class);
            PyClassNameCompletionContributor.addVariantsFromIndex(result, originalFile, PyVariableNameIndex.KEY, parent instanceof PyStringLiteralExpression ? STRING_LITERAL_INSERT_HANDLER : IMPORTING_INSERT_HANDLER, IS_TOPLEVEL, PyTargetExpression.class);
            PyClassNameCompletionContributor.addVariantsFromModules(result, originalFile, parent instanceof PyStringLiteralExpression);
        }
    }

    private static InsertHandler<LookupElement> getFunctionInsertHandler(PsiElement parent) {
        if (parent instanceof PyStringLiteralExpression) {
            return STRING_LITERAL_INSERT_HANDLER;
        }
        if (parent.getParent() instanceof PyDecorator) {
            return IMPORTING_INSERT_HANDLER;
        }
        return FUNCTION_INSERT_HANDLER;
    }

    private static void addVariantsFromModules(CompletionResultSet result, PsiFile targetFile, boolean inStringLiteral) {
        Collection<VirtualFile> files = FileTypeIndex.getFiles((FileType)PythonFileType.INSTANCE, PyProjectScopeBuilder.excludeSdkTestsScope((PsiElement)targetFile));
        for (VirtualFile file : files) {
            LookupElementBuilder element;
            PsiFile pyFile = targetFile.getManager().findFile(file);
            PsiFileSystemItem importable = (PsiFileSystemItem)PyUtil.turnInitIntoDir((PsiElement)pyFile);
            if (importable == null || !PythonReferenceImporter.isImportableModule(targetFile, importable) || (element = PyModuleType.buildFileLookupElement(importable, null)) == null) continue;
            result.addElement((LookupElement)element.withInsertHandler(inStringLiteral ? STRING_LITERAL_INSERT_HANDLER : IMPORTING_INSERT_HANDLER));
        }
    }

    private static <T extends PsiNamedElement> void addVariantsFromIndex(CompletionResultSet resultSet, PsiFile targetFile, StubIndexKey<String, T> key, InsertHandler<LookupElement> insertHandler, Condition<? super T> condition, Class<T> elementClass) {
        Project project = targetFile.getProject();
        GlobalSearchScope scope = PyProjectScopeBuilder.excludeSdkTestsScope((PsiElement)targetFile);
        Collection keys = StubIndex.getInstance().getAllKeys(key, project);
        for (String elementName : CompletionUtil.sortMatching(resultSet.getPrefixMatcher(), keys)) {
            for (PsiNamedElement element : StubIndex.getElements(key, (Object)elementName, (Project)project, (GlobalSearchScope)scope, elementClass)) {
                if (!condition.value((Object)element)) continue;
                resultSet.addElement((LookupElement)LookupElementBuilder.createWithIcon((PsiNamedElement)element).withTailText(" " + ((NavigationItem)element).getPresentation().getLocationString(), true).withInsertHandler(insertHandler));
            }
        }
    }

    private static void addImportForLookupElement(final InsertionContext context, final LookupElement item, int tailOffset) {
        PsiReference ref;
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)context.getProject());
        Document document = manager.getDocument(context.getFile());
        if (document != null) {
            manager.commitDocument(document);
        }
        if ((ref = context.getFile().findReferenceAt(tailOffset)) == null || ref.resolve() == item.getObject()) {
            return;
        }
        new WriteCommandAction(context.getProject(), new PsiFile[]{context.getFile()}){

            protected void run(Result result) throws Throwable {
                AddImportHelper.addImport((PsiNamedElement)item.getObject(), context.getFile(), (PyElement)ref.getElement());
            }
        }.execute();
    }
}

