/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.codeFragment;

import com.intellij.codeInsight.codeFragment.CannotCreateCodeFragmentException;
import com.intellij.codeInsight.codeFragment.CodeFragmentUtil;
import com.intellij.codeInsight.codeFragment.Position;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragment;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyLoopStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyForStatementNavigator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCodeFragmentUtil {
    private PyCodeFragmentUtil() {
    }

    @NotNull
    public static PyCodeFragment createCodeFragment(@NotNull ScopeOwner owner, @NotNull PsiElement startInScope, @NotNull PsiElement endInScope) throws CannotCreateCodeFragmentException {
        boolean yieldsFound;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "createCodeFragment"));
        }
        if (startInScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startInScope", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "createCodeFragment"));
        }
        if (endInScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endInScope", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "createCodeFragment"));
        }
        int start = startInScope.getTextOffset();
        int end = endInScope.getTextOffset() + endInScope.getTextLength();
        ControlFlow flow = ControlFlowCache.getControlFlow(owner);
        if (flow == null) {
            throw new CannotCreateCodeFragmentException("Cannot determine execution flow for the code fragment");
        }
        List<Instruction> graph = Arrays.asList(flow.getInstructions());
        List<Instruction> subGraph = PyCodeFragmentUtil.getFragmentSubGraph(graph, start, end);
        AnalysisResult subGraphAnalysis = PyCodeFragmentUtil.analyseSubGraph(subGraph, start, end);
        if (subGraphAnalysis.regularExits > 0 && subGraphAnalysis.returns > 0 || subGraphAnalysis.targetInstructions > 1 || subGraphAnalysis.outerLoopBreaks > 0) {
            throw new CannotCreateCodeFragmentException(PyBundle.message("refactoring.extract.method.error.cannot.perform.refactoring.when.execution.flow.is.interrupted", new Object[0]));
        }
        if (subGraphAnalysis.starImports > 0) {
            throw new CannotCreateCodeFragmentException(PyBundle.message("refactoring.extract.method.error.cannot.perform.refactoring.when.from.import.inside", new Object[0]));
        }
        Set<String> globalWrites = PyCodeFragmentUtil.getGlobalWrites(subGraph, owner);
        Set<String> nonlocalWrites = PyCodeFragmentUtil.getNonlocalWrites(subGraph, owner);
        HashSet<String> inputNames = new HashSet<String>();
        for (PsiElement element : PyCodeFragmentUtil.filterElementsInScope(PyCodeFragmentUtil.getInputElements(subGraph, graph), owner)) {
            String name = PyCodeFragmentUtil.getName(element);
            if (name == null || PyCodeFragmentUtil.resolvesToBoundMethodParameter(element) || globalWrites.contains(name) || nonlocalWrites.contains(name)) continue;
            inputNames.add(name);
        }
        HashSet<String> outputNames = new HashSet<String>();
        for (PsiElement element : PyCodeFragmentUtil.getOutputElements(subGraph, graph)) {
            String name = PyCodeFragmentUtil.getName(element);
            if (name == null || globalWrites.contains(name) || nonlocalWrites.contains(name)) continue;
            outputNames.add(name);
        }
        boolean bl = yieldsFound = subGraphAnalysis.yieldExpressions > 0;
        if (yieldsFound && LanguageLevel.forElement((PsiElement)owner).isOlderThan(LanguageLevel.PYTHON33)) {
            throw new CannotCreateCodeFragmentException("Cannot perform refactoring with 'yield' statement inside code block");
        }
        PyCodeFragment pyCodeFragment = new PyCodeFragment(inputNames, outputNames, globalWrites, nonlocalWrites, subGraphAnalysis.returns > 0, yieldsFound);
        if (pyCodeFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "createCodeFragment"));
        }
        return pyCodeFragment;
    }

    private static boolean resolvesToBoundMethodParameter(@NotNull PsiElement element) {
        PyFunction.Modifier modifier;
        PyParameter[] parameters;
        PyParameterList parameterList;
        PsiElement resolved;
        PsiReference reference;
        PyFunction function;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "resolvesToBoundMethodParameter"));
        }
        return PyPsiUtils.isMethodContext(element) && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class)) != null && (reference = element.getReference()) != null && (resolved = reference.resolve()) instanceof PyParameter && (parameterList = (PyParameterList)PsiTreeUtil.getParentOfType((PsiElement)resolved, PyParameterList.class)) != null && (parameters = parameterList.getParameters()).length > 0 && resolved == parameters[0] && ((modifier = function.getModifier()) == null || modifier == PyFunction.Modifier.CLASSMETHOD);
    }

    @Nullable
    private static String getName(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getName"));
        }
        if (element instanceof PsiNamedElement) {
            return ((PsiNamedElement)element).getName();
        }
        if (element instanceof PyImportElement) {
            return ((PyImportElement)element).getVisibleName();
        }
        if (element instanceof PyElement) {
            return ((PyElement)element).getName();
        }
        return null;
    }

    @NotNull
    private static List<Instruction> getFragmentSubGraph(@NotNull List<Instruction> graph, int start, int end) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getFragmentSubGraph"));
        }
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        for (Instruction instruction : graph) {
            PsiElement element = instruction.getElement();
            if (element == null || CodeFragmentUtil.getPosition(element, start, end) != Position.INSIDE) continue;
            instructions.add(instruction);
        }
        for (Instruction instruction : graph) {
            ReadWriteInstruction readWriteInstruction;
            if (!(instruction instanceof ReadWriteInstruction) || !(readWriteInstruction = (ReadWriteInstruction)instruction).getAccess().isAssertTypeAccess()) continue;
            boolean innerAssertType = true;
            for (Instruction next : readWriteInstruction.allSucc()) {
                if (instructions.contains(next)) continue;
                innerAssertType = false;
                break;
            }
            if (!innerAssertType || instructions.contains(instruction)) continue;
            instructions.add(instruction);
        }
        ArrayList<Instruction> arrayList = instructions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getFragmentSubGraph"));
        }
        return arrayList;
    }

    @NotNull
    private static AnalysisResult analyseSubGraph(@NotNull List<Instruction> subGraph, int start, int end) {
        if (subGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subGraph", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "analyseSubGraph"));
        }
        int returnSources = 0;
        int regularSources = 0;
        HashSet<Instruction> targetInstructions = new HashSet<Instruction>();
        int starImports = 0;
        int outerLoopBreaks = 0;
        int yieldExpressions = 0;
        for (Pair<Instruction, Instruction> edge : PyCodeFragmentUtil.getOutgoingEdges(subGraph)) {
            boolean isLoopTarget;
            Instruction sourceInstruction = (Instruction)edge.getFirst();
            Instruction targetInstruction = (Instruction)edge.getSecond();
            PsiElement source = sourceInstruction.getElement();
            PsiElement target = targetInstruction.getElement();
            PyReturnStatement returnStatement = (PyReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)source, PyReturnStatement.class, (boolean)false);
            boolean isExceptTarget = target instanceof PyExceptPart || target instanceof PyFinallyPart;
            boolean bl = isLoopTarget = target instanceof PyWhileStatement || PyForStatementNavigator.getPyForStatementByIterable(target) != null;
            if (target != null && !isExceptTarget && !isLoopTarget) {
                targetInstructions.add(targetInstruction);
            }
            if (returnStatement != null && CodeFragmentUtil.getPosition((PsiElement)returnStatement, start, end) == Position.INSIDE) {
                ++returnSources;
                continue;
            }
            if (isExceptTarget) continue;
            ++regularSources;
        }
        Set<PsiElement> subGraphElements = PyCodeFragmentUtil.getSubGraphElements(subGraph);
        for (PsiElement element : subGraphElements) {
            PyLoopStatement loopStatement;
            PyFromImportStatement fromImportStatement;
            if (element instanceof PyFromImportStatement && (fromImportStatement = (PyFromImportStatement)element).getStarImportElement() != null) {
                ++starImports;
            }
            if ((element instanceof PyContinueStatement || element instanceof PyBreakStatement) && (loopStatement = (PyLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyLoopStatement.class)) != null && !subGraphElements.contains(loopStatement)) {
                ++outerLoopBreaks;
            }
            if (!(element instanceof PyYieldExpression)) continue;
            ++yieldExpressions;
        }
        AnalysisResult analysisResult = new AnalysisResult(starImports, targetInstructions.size(), returnSources, regularSources, outerLoopBreaks, yieldExpressions);
        if (analysisResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "analyseSubGraph"));
        }
        return analysisResult;
    }

    @NotNull
    private static Set<Pair<Instruction, Instruction>> getOutgoingEdges(@NotNull Collection<Instruction> subGraph) {
        if (subGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subGraph", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getOutgoingEdges"));
        }
        HashSet<Pair<Instruction, Instruction>> outgoing = new HashSet<Pair<Instruction, Instruction>>();
        for (Instruction instruction : subGraph) {
            for (Instruction next : instruction.allSucc()) {
                if (subGraph.contains(next)) continue;
                outgoing.add((Pair<Instruction, Instruction>)Pair.create((Object)instruction, (Object)next));
            }
        }
        HashSet<Pair<Instruction, Instruction>> hashSet = outgoing;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getOutgoingEdges"));
        }
        return hashSet;
    }

    @NotNull
    public static List<PsiElement> getInputElements(@NotNull List<Instruction> subGraph, @NotNull List<Instruction> graph) {
        if (subGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subGraph", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getInputElements"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getInputElements"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        Set<PsiElement> subGraphElements = PyCodeFragmentUtil.getSubGraphElements(subGraph);
        for (Instruction instruction : PyCodeFragmentUtil.getReadInstructions(subGraph)) {
            PsiReference reference;
            PsiElement element = instruction.getElement();
            if (element == null || (reference = element.getReference()) == null) continue;
            for (PsiElement resolved : PyCodeFragmentUtil.multiResolve(reference)) {
                if (subGraphElements.contains(resolved)) continue;
                result.add(element);
            }
        }
        List<PsiElement> outputElements = PyCodeFragmentUtil.getOutputElements(subGraph, graph);
        for (Instruction instruction : PyCodeFragmentUtil.getWriteInstructions(subGraph)) {
            PsiReference reference;
            PsiElement element = instruction.getElement();
            if (element == null || (reference = element.getReference()) == null) continue;
            for (PsiElement resolved : PyCodeFragmentUtil.multiResolve(reference)) {
                if (subGraphElements.contains(resolved) || !outputElements.contains(element)) continue;
                result.add(element);
            }
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getInputElements"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiElement> getOutputElements(@NotNull List<Instruction> subGraph, @NotNull List<Instruction> graph) {
        if (subGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subGraph", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getOutputElements"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getOutputElements"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        ArrayList<Instruction> outerGraph = new ArrayList<Instruction>();
        for (Instruction instruction : graph) {
            if (subGraph.contains(instruction)) continue;
            outerGraph.add(instruction);
        }
        Set<PsiElement> subGraphElements = PyCodeFragmentUtil.getSubGraphElements(subGraph);
        for (Instruction instruction : PyCodeFragmentUtil.getReadInstructions(outerGraph)) {
            PsiReference reference;
            PsiElement element = instruction.getElement();
            if (element == null || (reference = element.getReference()) == null) continue;
            for (PsiElement resolved : PyCodeFragmentUtil.multiResolve(reference)) {
                if (!subGraphElements.contains(resolved)) continue;
                result.add(resolved);
            }
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getOutputElements"));
        }
        return arrayList;
    }

    private static List<PsiElement> filterElementsInScope(@NotNull Collection<PsiElement> elements, @NotNull ScopeOwner owner) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "filterElementsInScope"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "filterElementsInScope"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element : elements) {
            PsiElement resolved;
            PsiReference reference = element.getReference();
            if (reference == null || (resolved = reference.resolve()) == null || ScopeUtil.getScopeOwner(resolved) != owner || owner instanceof PsiFile) continue;
            result.add(element);
        }
        return result;
    }

    private static Set<PsiElement> getSubGraphElements(@NotNull List<Instruction> subGraph) {
        if (subGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subGraph", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getSubGraphElements"));
        }
        HashSet<PsiElement> result = new HashSet<PsiElement>();
        for (Instruction instruction : subGraph) {
            PsiElement element = instruction.getElement();
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    @NotNull
    private static Set<String> getGlobalWrites(@NotNull List<Instruction> instructions, @NotNull ScopeOwner owner) {
        if (instructions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructions", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getGlobalWrites"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getGlobalWrites"));
        }
        Scope scope = ControlFlowCache.getScope(owner);
        LinkedHashSet<String> globalWrites = new LinkedHashSet<String>();
        for (Instruction instruction : PyCodeFragmentUtil.getWriteInstructions(instructions)) {
            String name;
            if (!(instruction instanceof ReadWriteInstruction) || !scope.isGlobal(name = ((ReadWriteInstruction)instruction).getName()) && !(owner instanceof PsiFile)) continue;
            globalWrites.add(name);
        }
        LinkedHashSet<String> linkedHashSet = globalWrites;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getGlobalWrites"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static Set<String> getNonlocalWrites(@NotNull List<Instruction> instructions, @NotNull ScopeOwner owner) {
        if (instructions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructions", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getNonlocalWrites"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getNonlocalWrites"));
        }
        Scope scope = ControlFlowCache.getScope(owner);
        LinkedHashSet<String> nonlocalWrites = new LinkedHashSet<String>();
        for (Instruction instruction : PyCodeFragmentUtil.getWriteInstructions(instructions)) {
            String name;
            if (!(instruction instanceof ReadWriteInstruction) || !scope.isNonlocal(name = ((ReadWriteInstruction)instruction).getName())) continue;
            nonlocalWrites.add(name);
        }
        LinkedHashSet<String> linkedHashSet = nonlocalWrites;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getNonlocalWrites"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static List<PsiElement> multiResolve(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "multiResolve"));
        }
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            ArrayList<PsiElement> resolved = new ArrayList<PsiElement>();
            for (ResolveResult result : results) {
                PsiElement element = result.getElement();
                if (element == null) continue;
                resolved.add(element);
            }
            for (PsiElement element : resolved) {
                if (!(element instanceof PyClass)) continue;
                List<PsiElement> list = Collections.singletonList(element);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "multiResolve"));
                }
                return list;
            }
            ArrayList<PsiElement> arrayList = resolved;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "multiResolve"));
            }
            return arrayList;
        }
        PsiElement element = reference.resolve();
        if (element != null) {
            List<PsiElement> list = Collections.singletonList(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "multiResolve"));
            }
            return list;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "multiResolve"));
        }
        return list;
    }

    private static List<Instruction> getReadInstructions(@NotNull List<Instruction> subGraph) {
        if (subGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subGraph", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getReadInstructions"));
        }
        ArrayList<Instruction> result = new ArrayList<Instruction>();
        for (Instruction instruction : subGraph) {
            ReadWriteInstruction readWriteInstruction;
            if (!(instruction instanceof ReadWriteInstruction) || !(readWriteInstruction = (ReadWriteInstruction)instruction).getAccess().isReadAccess()) continue;
            result.add(readWriteInstruction);
        }
        return result;
    }

    private static List<Instruction> getWriteInstructions(@NotNull List<Instruction> subGraph) {
        if (subGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subGraph", "com/jetbrains/python/codeInsight/codeFragment/PyCodeFragmentUtil", "getWriteInstructions"));
        }
        ArrayList<Instruction> result = new ArrayList<Instruction>();
        for (Instruction instruction : subGraph) {
            ReadWriteInstruction readWriteInstruction;
            if (!(instruction instanceof ReadWriteInstruction) || !(readWriteInstruction = (ReadWriteInstruction)instruction).getAccess().isWriteAccess()) continue;
            result.add(readWriteInstruction);
        }
        return result;
    }

    private static class AnalysisResult {
        private final int starImports;
        private final int targetInstructions;
        private final int regularExits;
        private final int returns;
        private final int outerLoopBreaks;
        private final int yieldExpressions;

        public AnalysisResult(int starImports, int targetInstructions, int returns, int regularExits, int outerLoopBreaks, int yieldExpressions) {
            this.starImports = starImports;
            this.targetInstructions = targetInstructions;
            this.regularExits = regularExits;
            this.returns = returns;
            this.outerLoopBreaks = outerLoopBreaks;
            this.yieldExpressions = yieldExpressions;
        }
    }
}

