/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceOwner;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypingTypeProvider
extends PyTypeProviderBase {
    private static ImmutableMap<String, String> BUILTIN_COLLECTIONS = ImmutableMap.builder().put((Object)"typing.List", (Object)"list").put((Object)"typing.Dict", (Object)"dict").put((Object)"typing.Set", (Object)"set").put((Object)"typing.Tuple", (Object)"tuple").build();
    private static ImmutableSet<String> GENERIC_CLASSES = ImmutableSet.builder().add((Object)"typing.Generic").add((Object)"typing.AbstractGeneric").add((Object)"typing.Protocol").build();

    @Override
    public PyType getParameterType(@NotNull PyNamedParameter param, @NotNull PyFunction func, @NotNull TypeEvalContext context) {
        PyExpression value;
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getParameterType"));
        }
        if (func == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "func", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getParameterType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getParameterType"));
        }
        PyAnnotation annotation = param.getAnnotation();
        if (annotation != null && (value = annotation.getValue()) != null) {
            return PyTypingTypeProvider.getTypingType(value, context);
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull Callable callable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getReturnType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getReturnType"));
        }
        if (callable instanceof PyFunction) {
            PyExpression value;
            PyFunction function = (PyFunction)callable;
            PyAnnotation annotation = function.getAnnotation();
            if (annotation != null && (value = annotation.getValue()) != null) {
                return PyTypingTypeProvider.getTypingType(value, context);
            }
            PyType constructorType = PyTypingTypeProvider.getGenericConstructorType(function, context);
            if (constructorType != null) {
                return constructorType;
            }
        }
        return null;
    }

    @Nullable
    private static PyType getGenericConstructorType(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        List<PyGenericType> genericTypes;
        PyType elementType;
        PyClass cls;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getGenericConstructorType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getGenericConstructorType"));
        }
        if (PyUtil.isInit(function) && (cls = function.getContainingClass()) != null && (elementType = (genericTypes = PyTypingTypeProvider.collectGenericTypes(cls, context)).size() == 1 ? (PyType)genericTypes.get(0) : (genericTypes.size() > 1 ? PyTupleType.create(cls, genericTypes.toArray(new PyType[genericTypes.size()])) : null)) != null) {
            return new PyCollectionTypeImpl(cls, false, elementType);
        }
        return null;
    }

    @NotNull
    private static List<PyGenericType> collectGenericTypes(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "collectGenericTypes"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "collectGenericTypes"));
        }
        boolean isGeneric = false;
        for (PyClass ancestor : cls.getAncestorClasses(context)) {
            if (!GENERIC_CLASSES.contains((Object)ancestor.getQualifiedName())) continue;
            isGeneric = true;
            break;
        }
        if (isGeneric) {
            ArrayList<PyGenericType> results = new ArrayList<PyGenericType>();
            for (PyExpression expr : cls.getSuperClassExpressions()) {
                PyGenericType genericType;
                PyExpression indexExpr;
                if (!(expr instanceof PySubscriptionExpression) || (indexExpr = ((PySubscriptionExpression)expr).getIndexExpression()) == null || (genericType = PyTypingTypeProvider.getGenericType(indexExpr, context)) == null) continue;
                results.add(genericType);
            }
            ArrayList<PyGenericType> arrayList = results;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "collectGenericTypes"));
            }
            return arrayList;
        }
        List<PyGenericType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "collectGenericTypes"));
        }
        return list;
    }

    @Nullable
    private static PyType getTypingType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getTypingType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getTypingType"));
        }
        PyType unionType = PyTypingTypeProvider.getUnionType(expression, context);
        if (unionType != null) {
            return unionType;
        }
        PyType parameterizedType = PyTypingTypeProvider.getParameterizedType(expression, context);
        if (parameterizedType != null) {
            return parameterizedType;
        }
        PyType builtinCollection = PyTypingTypeProvider.getBuiltinCollection(expression, context);
        if (builtinCollection != null) {
            return builtinCollection;
        }
        PyGenericType genericType = PyTypingTypeProvider.getGenericType(expression, context);
        if (genericType != null) {
            return genericType;
        }
        PyType functionType = PyTypingTypeProvider.getFunctionType(expression, context);
        if (functionType != null) {
            return functionType;
        }
        PyType stringBasedType = PyTypingTypeProvider.getStringBasedType(expression, context);
        if (stringBasedType != null) {
            return stringBasedType;
        }
        return null;
    }

    @Nullable
    private static PyType getStringBasedType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getStringBasedType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getStringBasedType"));
        }
        if (expression instanceof PyStringLiteralExpression) {
            String contents = ((PyStringLiteralExpression)expression).getStringValue();
            Project project = expression.getProject();
            PyExpressionCodeFragmentImpl codeFragment = new PyExpressionCodeFragmentImpl(project, "dummy.py", contents, false);
            codeFragment.setContext((PsiElement)expression.getContainingFile());
            PsiElement element = codeFragment.getFirstChild();
            if (element instanceof PyExpressionStatement) {
                PyExpression dummyExpr = ((PyExpressionStatement)element).getExpression();
                return PyTypingTypeProvider.getType(dummyExpr, context);
            }
        }
        return null;
    }

    @Nullable
    private static PyType getFunctionType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        PyExpression parametersExpr;
        PyTupleExpression tupleExpr;
        PyExpression[] elements;
        PyExpression indexExpr;
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        String operandName;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getFunctionType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getFunctionType"));
        }
        if (expression instanceof PySubscriptionExpression && "typing.Function".equals(operandName = PyTypingTypeProvider.resolveToQualifiedName(operand = (subscriptionExpr = (PySubscriptionExpression)expression).getOperand(), context)) && (indexExpr = subscriptionExpr.getIndexExpression()) instanceof PyTupleExpression && (elements = (tupleExpr = (PyTupleExpression)indexExpr).getElements()).length == 2 && (parametersExpr = elements[0]) instanceof PyListLiteralExpression) {
            ArrayList<PyCallableParameter> parameters = new ArrayList<PyCallableParameter>();
            PyListLiteralExpression listExpr = (PyListLiteralExpression)parametersExpr;
            for (PyExpression argExpr : listExpr.getElements()) {
                parameters.add(new PyCallableParameterImpl(null, PyTypingTypeProvider.getType(argExpr, context)));
            }
            PyExpression returnTypeExpr = elements[1];
            PyType returnType = PyTypingTypeProvider.getType(returnTypeExpr, context);
            return new PyCallableTypeImpl(parameters, returnType);
        }
        return null;
    }

    @Nullable
    private static PyType getUnionType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        PySubscriptionExpression subscriptionExpr;
        PyExpression operand;
        String operandName;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getUnionType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getUnionType"));
        }
        if (expression instanceof PySubscriptionExpression && "typing.Union".equals(operandName = PyTypingTypeProvider.resolveToQualifiedName(operand = (subscriptionExpr = (PySubscriptionExpression)expression).getOperand(), context))) {
            return PyUnionType.union(PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context));
        }
        return null;
    }

    @Nullable
    private static PyGenericType getGenericType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        String name;
        PyExpression firstArgument;
        PyExpression[] arguments;
        String calleeQName;
        PyCallExpression assignedCall;
        PyExpression callee;
        PyExpression assigned;
        PyTargetExpression targetExpr;
        QualifiedName calleeName;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getGenericType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getGenericType"));
        }
        PsiElement resolved = PyTypingTypeProvider.resolve(expression, context);
        if (resolved instanceof PyTargetExpression && (calleeName = (targetExpr = (PyTargetExpression)resolved).getCalleeName()) != null && "typevar".equals(calleeName.toString()) && (assigned = targetExpr.findAssignedValue()) instanceof PyCallExpression && (callee = (assignedCall = (PyCallExpression)assigned).getCallee()) != null && "typing.typevar".equals(calleeQName = PyTypingTypeProvider.resolveToQualifiedName(callee, context)) && (arguments = assignedCall.getArguments()).length > 0 && (firstArgument = arguments[0]) instanceof PyStringLiteralExpression && (name = ((PyStringLiteralExpression)firstArgument).getStringValue()) != null) {
            return new PyGenericType(name, PyTypingTypeProvider.getGenericTypeBound(arguments, context));
        }
        return null;
    }

    @Nullable
    private static PyType getGenericTypeBound(@NotNull PyExpression[] typeVarArguments, @NotNull TypeEvalContext context) {
        PyKeywordArgument valuesArgument;
        PyExpression valueExpr;
        PyExpression secondArgument;
        if (typeVarArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeVarArguments", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getGenericTypeBound"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getGenericTypeBound"));
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        if (typeVarArguments.length > 1 && (secondArgument = typeVarArguments[1]) instanceof PyKeywordArgument && (valueExpr = PyPsiUtils.flattenParens((valuesArgument = (PyKeywordArgument)secondArgument).getValueExpression())) instanceof PyTupleExpression) {
            PyTupleExpression tupleExpr = (PyTupleExpression)valueExpr;
            for (PyExpression expr : tupleExpr.getElements()) {
                types.add(PyTypingTypeProvider.getType(expr, context));
            }
        }
        return PyUnionType.union(types);
    }

    @NotNull
    private static List<PyType> getIndexTypes(@NotNull PySubscriptionExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getIndexTypes"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getIndexTypes"));
        }
        ArrayList<PyType> types = new ArrayList<PyType>();
        PyExpression indexExpr = expression.getIndexExpression();
        if (indexExpr instanceof PyTupleExpression) {
            PyTupleExpression tupleExpr = (PyTupleExpression)indexExpr;
            for (PyExpression expr : tupleExpr.getElements()) {
                types.add(PyTypingTypeProvider.getType(expr, context));
            }
        }
        ArrayList<PyType> arrayList = types;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getIndexTypes"));
        }
        return arrayList;
    }

    @Nullable
    private static PyType getParameterizedType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getParameterizedType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getParameterizedType"));
        }
        if (expression instanceof PySubscriptionExpression) {
            PySubscriptionExpression subscriptionExpr = (PySubscriptionExpression)expression;
            PyExpression operand = subscriptionExpr.getOperand();
            PyExpression indexExpr = subscriptionExpr.getIndexExpression();
            PyType operandType = PyTypingTypeProvider.getType(operand, context);
            if (operandType instanceof PyClassType) {
                PyClass cls = ((PyClassType)operandType).getPyClass();
                if ("tuple".equals(cls.getQualifiedName())) {
                    List<PyType> indexTypes = PyTypingTypeProvider.getIndexTypes(subscriptionExpr, context);
                    return PyTupleType.create((PsiElement)expression, indexTypes.toArray(new PyType[indexTypes.size()]));
                }
                if (indexExpr != null) {
                    PyType indexType = context.getType(indexExpr);
                    return new PyCollectionTypeImpl(cls, false, indexType);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PyType getBuiltinCollection(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getBuiltinCollection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getBuiltinCollection"));
        }
        String collectionName = PyTypingTypeProvider.resolveToQualifiedName(expression, context);
        String builtinName = (String)BUILTIN_COLLECTIONS.get((Object)collectionName);
        return builtinName != null ? PyTypeParser.getTypeByName((PsiElement)expression, builtinName) : null;
    }

    @Nullable
    private static PyType getType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "getType"));
        }
        PyType typingType = PyTypingTypeProvider.getTypingType(expression, context);
        if (typingType != null) {
            return typingType;
        }
        PyType type = context.getType(expression);
        if (type instanceof PyClassLikeType) {
            PyClassLikeType classType = (PyClassLikeType)type;
            if (classType.isDefinition()) {
                return classType.toInstance();
            }
        } else if (type instanceof PyNoneType) {
            return type;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolve(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "resolve"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "resolve"));
        }
        if (expression instanceof PyReferenceOwner) {
            PyClass cls;
            PyFunction function;
            PyReferenceOwner referenceOwner = (PyReferenceOwner)((Object)expression);
            PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(context);
            PsiPolyVariantReference reference = referenceOwner.getReference(resolveContext);
            PsiElement element = reference.resolve();
            if (element instanceof PyFunction && PyUtil.isInit(function = (PyFunction)element) && (cls = function.getContainingClass()) != null) {
                return cls;
            }
            return element;
        }
        return null;
    }

    @Nullable
    private static String resolveToQualifiedName(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "resolveToQualifiedName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyTypingTypeProvider", "resolveToQualifiedName"));
        }
        PsiElement element = PyTypingTypeProvider.resolve(expression, context);
        if (element instanceof PyQualifiedNameOwner) {
            PyQualifiedNameOwner qualifiedNameOwner = (PyQualifiedNameOwner)element;
            return qualifiedNameOwner.getQualifiedName();
        }
        return null;
    }
}

