/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.resolve.QualifiedNameResolver;
import org.jetbrains.annotations.Nullable;

public abstract class PyPsiPath {
    @Nullable
    public abstract PsiElement resolve(PsiElement var1);

    private static class AssignmentFinder
    extends PyRecursiveElementVisitor {
        private final String myAssignee;
        private PsiElement myResult;

        public AssignmentFinder(String assignee) {
            this.myAssignee = assignee;
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyExpression lhs = node.getLeftHandSideExpression();
            if (lhs != null && this.myAssignee.equals(lhs.getText())) {
                this.myResult = node;
            }
        }
    }

    public static class ToAssignment
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myAssignee;

        public ToAssignment(PyPsiPath parent, String assignee) {
            this.myParent = parent;
            this.myAssignee = assignee;
        }

        @Override
        @Nullable
        public PsiElement resolve(PsiElement context) {
            PsiElement parent = this.myParent.resolve(context);
            if (parent == null) {
                return null;
            }
            AssignmentFinder finder = new AssignmentFinder(this.myAssignee);
            parent.accept((PsiElementVisitor)finder);
            return finder.myResult != null ? finder.myResult : parent;
        }
    }

    private static class CallFinder
    extends PyRecursiveElementVisitor {
        private PsiElement myResult;
        private final String myCallName;
        private final String[] myArgs;

        public CallFinder(String callName, String[] args) {
            this.myCallName = callName;
            this.myArgs = args;
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyExpression[] args;
            String calleeName;
            if (this.myResult != null) {
                return;
            }
            super.visitPyCallExpression(node);
            PyExpression callee = node.getCallee();
            if (callee instanceof PyReferenceExpression && this.myCallName.equals(calleeName = ((PyReferenceExpression)callee).getReferencedName()) && this.myArgs.length <= (args = node.getArguments()).length) {
                boolean argsMatch = true;
                for (int i = 0; i < this.myArgs.length; ++i) {
                    if (args[i] instanceof PyStringLiteralExpression && this.myArgs[i].equals(((PyStringLiteralExpression)args[i]).getStringValue())) continue;
                    argsMatch = false;
                    break;
                }
                if (argsMatch) {
                    this.myResult = node;
                }
            }
        }
    }

    public static class ToCall
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myCallName;
        private final String[] myArgs;

        public ToCall(PyPsiPath parent, String callName, String ... args) {
            this.myParent = parent;
            this.myCallName = callName;
            this.myArgs = args;
        }

        @Override
        public PsiElement resolve(PsiElement context) {
            PsiElement parent = this.myParent.resolve(context);
            if (parent == null) {
                return null;
            }
            CallFinder finder = new CallFinder(this.myCallName, this.myArgs);
            parent.accept((PsiElementVisitor)finder);
            return finder.myResult != null ? finder.myResult : parent;
        }
    }

    public static class ToClassAttribute
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myAttributeName;

        public ToClassAttribute(PyPsiPath parent, String attributeName) {
            this.myAttributeName = attributeName;
            this.myParent = parent;
        }

        @Override
        public PsiElement resolve(PsiElement context) {
            PsiElement parent = this.myParent.resolve(context);
            if (!(parent instanceof PyClass)) {
                return null;
            }
            return ((PyClass)parent).findClassAttribute(this.myAttributeName, true);
        }
    }

    public static class ToFunctionRecursive
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myFunctionName;

        public ToFunctionRecursive(PyPsiPath parent, String functionName) {
            this.myParent = parent;
            this.myFunctionName = functionName;
        }

        @Override
        public PsiElement resolve(PsiElement context) {
            PsiElement parent = this.myParent.resolve(context);
            if (parent == null) {
                return null;
            }
            FunctionFinder finder = new FunctionFinder(this.myFunctionName);
            parent.acceptChildren((PsiElementVisitor)finder);
            return finder.myResult != null ? finder.myResult : parent;
        }
    }

    private static class FunctionFinder
    extends PyRecursiveElementVisitor {
        private final String myName;
        private PyFunction myResult;

        public FunctionFinder(String name) {
            this.myName = name;
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            super.visitPyFunction(node);
            if (this.myName.equals(node.getName())) {
                this.myResult = node;
            }
        }
    }

    public static class ToFunction
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myFunctionName;

        public ToFunction(PyPsiPath parent, String functionName) {
            this.myParent = parent;
            this.myFunctionName = functionName;
        }

        @Override
        public PsiElement resolve(PsiElement context) {
            PsiElement parent = this.myParent.resolve(context);
            if (parent == null) {
                return null;
            }
            if (parent instanceof PyFile) {
                return ((PyFile)parent).findTopLevelFunction(this.myFunctionName);
            }
            if (parent instanceof PyClass) {
                return ((PyClass)parent).findMethodByName(this.myFunctionName, false);
            }
            for (PsiElement element : parent.getChildren()) {
                if (!(element instanceof PyFunction) || !this.myFunctionName.equals(((PyFunction)element).getName())) continue;
                return element;
            }
            return parent;
        }
    }

    private static class ClassFinder
    extends PyRecursiveElementVisitor {
        private final String myName;
        private PyClass myResult;

        public ClassFinder(String name) {
            this.myName = name;
        }

        @Override
        public void visitPyClass(PyClass node) {
            super.visitPyClass(node);
            if (this.myName.equals(node.getName())) {
                this.myResult = node;
            }
        }
    }

    public static class ToClass
    extends PyPsiPath {
        private final PyPsiPath myParent;
        private final String myClassName;

        public ToClass(PyPsiPath parent, String className) {
            this.myParent = parent;
            this.myClassName = className;
        }

        @Override
        public PsiElement resolve(PsiElement context) {
            PsiElement parent = this.myParent.resolve(context);
            if (parent == null) {
                return null;
            }
            if (parent instanceof PyFile) {
                return ((PyFile)parent).findTopLevelClass(this.myClassName);
            }
            if (parent instanceof PyClass) {
                for (PsiElement element : parent.getChildren()) {
                    if (!(element instanceof PyClass) || !this.myClassName.equals(((PyClass)element).getName())) continue;
                    return element;
                }
            }
            ClassFinder finder = new ClassFinder(this.myClassName);
            parent.acceptChildren((PsiElementVisitor)finder);
            return finder.myResult != null ? finder.myResult : parent;
        }
    }

    public static class ToClassQName
    extends PyPsiPath {
        private final QualifiedName myQualifiedName;

        public ToClassQName(String qualifiedName) {
            this.myQualifiedName = QualifiedName.fromDottedString((String)qualifiedName);
        }

        @Override
        @Nullable
        public PsiElement resolve(PsiElement context) {
            return PyPsiFacade.getInstance(context.getProject()).findClass(this.myQualifiedName.toString());
        }
    }

    public static class ToFile
    extends PyPsiPath {
        private final QualifiedName myQualifiedName;

        public ToFile(String qualifiedName) {
            this.myQualifiedName = QualifiedName.fromDottedString((String)qualifiedName);
        }

        @Override
        @Nullable
        public PsiElement resolve(PsiElement context) {
            PyPsiFacade pyPsiFacade = PyPsiFacade.getInstance(context.getProject());
            QualifiedNameResolver visitor = pyPsiFacade.qualifiedNameResolver(this.myQualifiedName).fromElement(context);
            return visitor.firstResult();
        }
    }
}

