/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;

public class PyMethodNameTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result beforeCharTyped(char character, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (!(fileType instanceof PythonFileType)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (character == '(') {
            PyFunction func;
            PyUtil.MethodFlags flags;
            PsiElement maybe_func;
            ASTNode def_node;
            PsiElement maybe_def;
            if (!PyCodeInsightSettings.getInstance().INSERT_SELF_FOR_METHODS) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            Document document = editor.getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            int offset = editor.getCaretModel().getOffset();
            PsiElement token = file.findElementAt(offset - 1);
            if (token == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            ASTNode token_node = token.getNode();
            if (token_node != null && token_node.getElementType() == PyTokenTypes.IDENTIFIER && (maybe_def = PyUtil.getFirstNonCommentBefore(token.getPrevSibling())) != null && (def_node = maybe_def.getNode()) != null && def_node.getElementType() == PyTokenTypes.DEF_KEYWORD && (maybe_func = token.getParent()) instanceof PyFunction && (flags = PyUtil.MethodFlags.of(func = (PyFunction)maybe_func)) != null) {
                String pname = flags.isClassMethod() || flags.isMetaclassMethod() ? "cls" : "self";
                boolean is_new = "__new__".equals(func.getName());
                if (flags.isMetaclassMethod() && is_new) {
                    pname = "typ";
                } else if (flags.isClassMethod() || is_new) {
                    pname = "cls";
                } else if (flags.isStaticMethod()) {
                    pname = "";
                }
                documentManager.commitDocument(document);
                int caretOffset = editor.getCaretModel().getOffset();
                String textToType = "(" + pname + ")";
                CharSequence chars = editor.getDocument().getCharsSequence();
                if (caretOffset == chars.length() || chars.charAt(caretOffset) != ':') {
                    textToType = textToType + ':';
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)textToType, (boolean)true, (int)(1 + pname.length()));
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

