/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public class PyLineSeparatorUtil {
    private PyLineSeparatorUtil() {
    }

    @Nullable
    public static LineMarkerInfo addLineSeparatorIfNeeded(final Provider provider, final PsiElement element) {
        final Ref info = new Ref(null);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (!provider.isSeparatorAllowed(element)) {
                    return;
                }
                boolean hasSeparableBefore = false;
                PsiElement parent = element.getParent();
                if (parent == null) {
                    return;
                }
                for (PsiElement child : parent.getChildren()) {
                    if (child == element) break;
                    if (!provider.isSeparatorAllowed(child)) continue;
                    hasSeparableBefore = true;
                    break;
                }
                if (!hasSeparableBefore) {
                    return;
                }
                info.set((Object)PyLineSeparatorUtil.createLineSeparatorByElement(element));
            }
        });
        return (LineMarkerInfo)info.get();
    }

    private static LineMarkerInfo<PsiElement> createLineSeparatorByElement(PsiElement element) {
        LineMarkerInfo info = new LineMarkerInfo(element, element.getTextRange().getStartOffset(), null, 4, null, null);
        info.separatorColor = EditorColorsManager.getInstance().getGlobalScheme().getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
        info.separatorPlacement = SeparatorPlacement.TOP;
        return info;
    }

    public static interface Provider {
        public boolean isSeparatorAllowed(PsiElement var1);
    }
}

