/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.PyLineMarkerNavigator;
import com.jetbrains.python.codeInsight.PyLineSeparatorUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLineMarkerProvider
implements LineMarkerProvider,
PyLineSeparatorUtil.Provider {
    private static final Function<PyClass, String> ourSubclassTooltipProvider = new Function<PyClass, String>(){

        public String fun(PyClass pyClass) {
            final StringBuilder builder = new StringBuilder("<html>Is subclassed by:");
            final AtomicInteger count = new AtomicInteger();
            PyClassInheritorsSearch.search(pyClass, true).forEach((Processor)new Processor<PyClass>(){

                public boolean process(PyClass pyClass) {
                    if (count.incrementAndGet() >= 10) {
                        builder.setLength(0);
                        builder.append("Has subclasses");
                        return false;
                    }
                    builder.append("<br>&nbsp;&nbsp;").append(pyClass.getName());
                    return true;
                }
            });
            return builder.toString();
        }
    };
    private static final Function<PyFunction, String> ourOverridingMethodTooltipProvider = new Function<PyFunction, String>(){

        public String fun(final PyFunction pyFunction) {
            final StringBuilder builder = new StringBuilder("<html>Is overridden in:");
            final AtomicInteger count = new AtomicInteger();
            PyClassInheritorsSearch.search(pyFunction.getContainingClass(), true).forEach((Processor)new Processor<PyClass>(){

                public boolean process(PyClass pyClass) {
                    if (count.incrementAndGet() >= 10) {
                        builder.setLength(0);
                        builder.append("Has overridden methods");
                        return false;
                    }
                    if (pyClass.findMethodByName(pyFunction.getName(), false) != null) {
                        builder.append("<br>&nbsp;&nbsp;").append(pyClass.getName());
                    }
                    return true;
                }
            });
            return builder.toString();
        }
    };
    private static final PyLineMarkerNavigator<PsiElement> ourSuperMethodNavigator = new PyLineMarkerNavigator<PsiElement>(){

        @Override
        protected String getTitle(PsiElement elt) {
            return "Choose Super Method of " + ((PyFunction)elt.getParent()).getName();
        }

        @Override
        @Nullable
        protected Query<PsiElement> search(PsiElement elt) {
            if (!(elt.getParent() instanceof PyFunction)) {
                return null;
            }
            return PySuperMethodsSearch.search((PyFunction)elt.getParent());
        }
    };
    private static final PyLineMarkerNavigator<PsiElement> ourSuperAttributeNavigator = new PyLineMarkerNavigator<PsiElement>(){

        @Override
        protected String getTitle(PsiElement elt) {
            return "Choose Super Attribute of " + ((PyTargetExpression)elt).getName();
        }

        @Override
        @Nullable
        protected Query<PsiElement> search(PsiElement elt) {
            ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)elt, PyClass.class);
            if (containingClass != null && elt instanceof PyTargetExpression) {
                for (PyClass ancestor : containingClass.getAncestorClasses()) {
                    PyTargetExpression attribute = ancestor.findClassAttribute(((PyTargetExpression)elt).getReferencedName(), false);
                    if (attribute == null) continue;
                    result.add(attribute);
                }
            }
            return new CollectionQuery(result);
        }
    };
    private static final PyLineMarkerNavigator<PyClass> ourSubclassNavigator = new PyLineMarkerNavigator<PyClass>(){

        @Override
        protected String getTitle(PyClass elt) {
            return "Choose Subclass of " + elt.getName();
        }

        @Override
        protected Query<PyClass> search(PyClass elt) {
            return PyClassInheritorsSearch.search(elt, true);
        }
    };
    private static final PyLineMarkerNavigator<PyFunction> ourOverridingMethodNavigator = new PyLineMarkerNavigator<PyFunction>(){

        @Override
        protected String getTitle(PyFunction elt) {
            return "Choose Overriding Method of " + elt.getName();
        }

        @Override
        protected Query<PyFunction> search(PyFunction elt) {
            return PyOverridingMethodsSearch.search(elt, true);
        }
    };

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/PyLineMarkerProvider", "getLineMarkerInfo"));
        }
        ASTNode node = element.getNode();
        if (node != null && node.getElementType() == PyTokenTypes.IDENTIFIER && element.getParent() instanceof PyFunction) {
            PyFunction function = (PyFunction)element.getParent();
            return PyLineMarkerProvider.getMethodMarker(element, function);
        }
        if (element instanceof PyTargetExpression && PyUtil.isClassAttribute(element)) {
            return PyLineMarkerProvider.getAttributeMarker((PyTargetExpression)element);
        }
        if (DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS && this.isSeparatorAllowed(element)) {
            return PyLineSeparatorUtil.addLineSeparatorIfNeeded(this, element);
        }
        return null;
    }

    @Override
    public boolean isSeparatorAllowed(PsiElement element) {
        return element instanceof PyFunction || element instanceof PyClass;
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> getMethodMarker(PsiElement element, PyFunction function) {
        if ("__init__".equals(function.getName())) {
            return null;
        }
        PsiElement superMethod = (PsiElement)PySuperMethodsSearch.search(function).findFirst();
        if (superMethod != null) {
            PyClass superClass = null;
            if (superMethod instanceof PyFunction) {
                superClass = ((PyFunction)superMethod).getContainingClass();
            }
            return new LineMarkerInfo(element, element.getTextRange().getStartOffset(), AllIcons.Gutter.OverridingMethod, 4, (Function)(superClass == null ? null : new TooltipProvider("Overrides method in " + superClass.getName())), ourSuperMethodNavigator);
        }
        return null;
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> getAttributeMarker(PyTargetExpression element) {
        String name = element.getReferencedName();
        if (name == null) {
            return null;
        }
        PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        if (containingClass == null) {
            return null;
        }
        for (PyClass ancestor : containingClass.getAncestorClasses()) {
            PyTargetExpression ancestorAttr = ancestor.findClassAttribute(name, false);
            if (ancestorAttr == null) continue;
            return new LineMarkerInfo((PsiElement)element, element.getTextRange().getStartOffset(), AllIcons.Gutter.OverridingMethod, 4, (Function)new TooltipProvider("Overrides attribute in " + ancestor.getName()), ourSuperAttributeNavigator);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/python/codeInsight/PyLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/PyLineMarkerProvider", "collectSlowLineMarkers"));
        }
        HashSet functions = new HashSet();
        for (PsiElement element : elements) {
            if (element instanceof PyClass) {
                PyLineMarkerProvider.collectInheritingClasses((PyClass)element, result);
                continue;
            }
            if (!(element instanceof PyFunction)) continue;
            functions.add((PyFunction)element);
        }
        PyLineMarkerProvider.collectOverridingMethods((Set<PyFunction>)functions, result);
    }

    private static void collectInheritingClasses(PyClass element, Collection<LineMarkerInfo> result) {
        if (PyClassInheritorsSearch.search(element, false).findFirst() != null) {
            result.add(new LineMarkerInfo((PsiElement)element, element.getTextOffset(), AllIcons.Gutter.OverridenMethod, 6, ourSubclassTooltipProvider, ourSubclassNavigator));
        }
    }

    private static void collectOverridingMethods(Set<PyFunction> functions, Collection<LineMarkerInfo> result) {
        HashSet classes = new HashSet();
        final MultiMap candidates = new MultiMap();
        for (PyFunction function : functions) {
            final PyClass pyClass = function.getContainingClass();
            if (pyClass == null || function.getName() == null) continue;
            classes.add(pyClass);
            candidates.putValue((Object)pyClass, (Object)function);
        }
        HashSet overridden = new HashSet();
        for (final PyClass pyClass : classes) {
            PyClassInheritorsSearch.search(pyClass, true).forEach((Processor)new Processor<PyClass>((Set)overridden){
                final /* synthetic */ Set val$overridden;
                {
                    this.val$overridden = set;
                }

                public boolean process(PyClass inheritor) {
                    Iterator it = candidates.get((Object)pyClass).iterator();
                    while (it.hasNext()) {
                        PyFunction func = (PyFunction)it.next();
                        if (inheritor.findMethodByName(func.getName(), false) == null) continue;
                        this.val$overridden.add(func);
                        it.remove();
                    }
                    return !candidates.isEmpty();
                }
            });
            if (!candidates.isEmpty()) continue;
            break;
        }
        for (PyFunction func : overridden) {
            result.add(new LineMarkerInfo((PsiElement)func, func.getTextOffset(), AllIcons.Gutter.OverridenMethod, 6, ourOverridingMethodTooltipProvider, ourOverridingMethodNavigator));
        }
    }

    private static class TooltipProvider
    implements Function<PsiElement, String> {
        private final String myText;

        private TooltipProvider(String text) {
            this.myText = text;
        }

        public String fun(PsiElement psiElement) {
            return this.myText;
        }
    }
}

