/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInjectionUtil {
    public static final List<Class<? extends PyExpression>> ELEMENTS_TO_INJECT_IN = Arrays.asList(PyStringLiteralExpression.class, PyParenthesizedExpression.class, PyBinaryExpression.class, PyCallExpression.class);

    private PyInjectionUtil() {
    }

    @Nullable
    public static PsiElement getLargestStringLiteral(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyInjectionUtil", "getLargestStringLiteral"));
        }
        PsiElement element = null;
        for (PsiElement current = context; current != null && PyInjectionUtil.isStringLiteralPart(current, element); current = current.getParent()) {
            element = current;
        }
        return element;
    }

    @NotNull
    public static InjectionResult registerStringLiteralInjection(@NotNull PsiElement element, @NotNull MultiHostRegistrar registrar) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/PyInjectionUtil", "registerStringLiteralInjection"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/python/codeInsight/PyInjectionUtil", "registerStringLiteralInjection"));
        }
        InjectionResult injectionResult = PyInjectionUtil.processStringLiteral(element, registrar, "", "", Formatting.PERCENT);
        if (injectionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyInjectionUtil", "registerStringLiteralInjection"));
        }
        return injectionResult;
    }

    private static boolean isStringLiteralPart(@NotNull PsiElement element, @Nullable PsiElement context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/PyInjectionUtil", "isStringLiteralPart"));
        }
        if (element == context) {
            return true;
        }
        if (element instanceof PyStringLiteralExpression) {
            return true;
        }
        if (element instanceof PyParenthesizedExpression) {
            PyExpression contained = ((PyParenthesizedExpression)element).getContainedExpression();
            return contained != null && PyInjectionUtil.isStringLiteralPart((PsiElement)contained, context);
        }
        if (element instanceof PyBinaryExpression) {
            PyBinaryExpression expr = (PyBinaryExpression)element;
            PyExpression left = expr.getLeftExpression();
            PyExpression right = expr.getRightExpression();
            if (expr.isOperator("+")) {
                return PyInjectionUtil.isStringLiteralPart((PsiElement)left, context) || right != null && PyInjectionUtil.isStringLiteralPart((PsiElement)right, context);
            }
            if (expr.isOperator("%")) {
                return right != context && PyInjectionUtil.isStringLiteralPart((PsiElement)left, context);
            }
            return false;
        }
        if (element instanceof PyCallExpression) {
            PyExpression qualifier = PyInjectionUtil.getFormatCallQualifier((PyCallExpression)element);
            return qualifier != null && PyInjectionUtil.isStringLiteralPart((PsiElement)qualifier, context);
        }
        return false;
    }

    @Nullable
    private static PyExpression getFormatCallQualifier(@NotNull PyCallExpression element) {
        PyQualifiedExpression qualifiedExpr;
        PyExpression qualifier;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/PyInjectionUtil", "getFormatCallQualifier"));
        }
        PyExpression callee = element.getCallee();
        if (callee instanceof PyQualifiedExpression && (qualifier = (qualifiedExpr = (PyQualifiedExpression)callee).getQualifier()) != null && "format".equals(qualifiedExpr.getReferencedName())) {
            return qualifier;
        }
        return null;
    }

    @NotNull
    private static InjectionResult processStringLiteral(@NotNull PsiElement element, @NotNull MultiHostRegistrar registrar, @NotNull String prefix, @NotNull String suffix, @NotNull Formatting formatting) {
        PyExpression qualifier;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
        }
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
        }
        if (formatting == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatting", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
        }
        String missingValue = "missing_value";
        if (element instanceof PyStringLiteralExpression) {
            boolean injected = false;
            boolean strict = true;
            PyStringLiteralExpression expr = (PyStringLiteralExpression)element;
            List<TextRange> ranges = expr.getStringValueTextRanges();
            String text = expr.getText();
            for (TextRange range : ranges) {
                if (formatting != Formatting.NONE) {
                    List<PyStringFormatParser.FormatStringChunk> chunks;
                    String part = range.substring(text);
                    List<PyStringFormatParser.FormatStringChunk> list = chunks = formatting == Formatting.NEW_STYLE ? PyStringFormatParser.parseNewStyleFormat(part) : PyStringFormatParser.parsePercentFormat(part);
                    if (!PyStringFormatParser.filterSubstitutions(chunks).isEmpty()) {
                        strict = false;
                    }
                    for (int i = 0; i < chunks.size(); ++i) {
                        PyStringFormatParser.FormatStringChunk chunk = chunks.get(i);
                        if (!(chunk instanceof PyStringFormatParser.ConstantChunk)) continue;
                        int nextIndex = i + 1;
                        String chunkPrefix = i == 1 && chunks.get(0) instanceof PyStringFormatParser.SubstitutionChunk ? "missing_value" : (i == 0 ? prefix : "");
                        String chunkSuffix = nextIndex < chunks.size() && chunks.get(nextIndex) instanceof PyStringFormatParser.SubstitutionChunk ? "missing_value" : (nextIndex == chunks.size() ? suffix : "");
                        TextRange chunkRange = chunk.getTextRange().shiftRight(range.getStartOffset());
                        registrar.addPlace(chunkPrefix, chunkSuffix, (PsiLanguageInjectionHost)expr, chunkRange);
                        injected = true;
                    }
                    continue;
                }
                registrar.addPlace(prefix, suffix, (PsiLanguageInjectionHost)expr, range);
                injected = true;
            }
            InjectionResult injectionResult = new InjectionResult(injected, strict);
            if (injectionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
            }
            return injectionResult;
        }
        if (element instanceof PyParenthesizedExpression) {
            PyExpression contained = ((PyParenthesizedExpression)element).getContainedExpression();
            if (contained != null) {
                InjectionResult injectionResult = PyInjectionUtil.processStringLiteral((PsiElement)contained, registrar, prefix, suffix, formatting);
                if (injectionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
                }
                return injectionResult;
            }
        } else if (element instanceof PyBinaryExpression) {
            PyBinaryExpression expr = (PyBinaryExpression)element;
            PyExpression left = expr.getLeftExpression();
            PyExpression right = expr.getRightExpression();
            boolean isLeftString = PyInjectionUtil.isStringLiteralPart((PsiElement)left, null);
            if (expr.isOperator("+")) {
                boolean isRightString = right != null && PyInjectionUtil.isStringLiteralPart((PsiElement)right, null);
                InjectionResult result = InjectionResult.EMPTY;
                if (isLeftString) {
                    result = result.append(PyInjectionUtil.processStringLiteral((PsiElement)left, registrar, prefix, isRightString ? "" : "missing_value", formatting));
                }
                if (isRightString) {
                    result = result.append(PyInjectionUtil.processStringLiteral((PsiElement)right, registrar, isLeftString ? "" : "missing_value", suffix, formatting));
                }
                InjectionResult injectionResult = result;
                if (injectionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
                }
                return injectionResult;
            }
            if (expr.isOperator("%")) {
                InjectionResult injectionResult = PyInjectionUtil.processStringLiteral((PsiElement)left, registrar, prefix, suffix, Formatting.PERCENT);
                if (injectionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
                }
                return injectionResult;
            }
        } else if (element instanceof PyCallExpression && (qualifier = PyInjectionUtil.getFormatCallQualifier((PyCallExpression)element)) != null) {
            InjectionResult injectionResult = PyInjectionUtil.processStringLiteral((PsiElement)qualifier, registrar, prefix, suffix, Formatting.NEW_STYLE);
            if (injectionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
            }
            return injectionResult;
        }
        InjectionResult injectionResult = InjectionResult.EMPTY;
        if (injectionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyInjectionUtil", "processStringLiteral"));
        }
        return injectionResult;
    }

    private static enum Formatting {
        NONE,
        PERCENT,
        NEW_STYLE;

    }

    public static class InjectionResult {
        public static InjectionResult EMPTY = new InjectionResult(false, true);
        private final boolean myInjected;
        private final boolean myStrict;

        private InjectionResult(boolean injected, boolean strict) {
            this.myInjected = injected;
            this.myStrict = strict;
        }

        public boolean isInjected() {
            return this.myInjected;
        }

        public boolean isStrict() {
            return this.myStrict;
        }

        public InjectionResult append(@NotNull InjectionResult result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/codeInsight/PyInjectionUtil$InjectionResult", "append"));
            }
            return new InjectionResult(this.myInjected || result.isInjected(), this.myStrict && result.isStrict());
        }
    }
}

