/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PyGotoSuperHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/codeInsight/PyGotoSuperHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/codeInsight/PyGotoSuperHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/codeInsight/PyGotoSuperHandler", "invoke"));
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        if (pyClass != null) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class});
            if (function != null) {
                PyGotoSuperHandler.gotoSuperFunctions(editor, function, pyClass);
            } else {
                PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class, (boolean)false, (Class[])new Class[]{PyClass.class});
                if (assignment != null && assignment.getTargets()[0] instanceof PyTargetExpression) {
                    PyGotoSuperHandler.gotoSuperClassAttributes(editor, (PyTargetExpression)assignment.getTargets()[0], pyClass);
                } else {
                    PyGotoSuperHandler.navigateOrChoose(editor, PyUtil.getAllSuperClasses(pyClass), "Choose superclass");
                }
            }
        }
    }

    private static void gotoSuperFunctions(Editor editor, PyFunction function, PyClass pyClass) {
        Collection<PyFunction> superFunctions = PyGotoSuperHandler.getAllSuperMethodsByName(function, pyClass);
        PyGotoSuperHandler.navigateOrChoose(editor, superFunctions, CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]));
    }

    private static void gotoSuperClassAttributes(Editor editor, PyTargetExpression attr, PyClass pyClass) {
        Collection<PyTargetExpression> attrs = PyGotoSuperHandler.getAllSuperAttributesByName(attr, pyClass);
        PyGotoSuperHandler.navigateOrChoose(editor, attrs, "Choose superclass attribute");
    }

    private static void navigateOrChoose(Editor editor, Collection<? extends NavigatablePsiElement> superElements, String title) {
        if (!superElements.isEmpty()) {
            NavigatablePsiElement[] superElementArray = superElements.toArray(new NavigatablePsiElement[superElements.size()]);
            if (superElementArray.length == 1) {
                superElementArray[0].navigate(true);
            } else {
                NavigationUtil.getPsiElementPopup((PsiElement[])superElementArray, title).showInBestPositionFor(editor);
            }
        }
    }

    private static Collection<PyTargetExpression> getAllSuperAttributesByName(@NotNull PyTargetExpression classAttr, PyClass pyClass) {
        if (classAttr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classAttr", "com/jetbrains/python/codeInsight/PyGotoSuperHandler", "getAllSuperAttributesByName"));
        }
        String name = classAttr.getName();
        if (name == null) {
            return Collections.emptyList();
        }
        ArrayList<PyTargetExpression> result = new ArrayList<PyTargetExpression>();
        for (PyClass aClass : pyClass.getAncestorClasses()) {
            PyTargetExpression superAttr = aClass.findClassAttribute(name, false);
            if (superAttr == null) continue;
            result.add(superAttr);
        }
        return result;
    }

    private static Collection<PyFunction> getAllSuperMethodsByName(@NotNull PyFunction method, PyClass pyClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/jetbrains/python/codeInsight/PyGotoSuperHandler", "getAllSuperMethodsByName"));
        }
        String name = method.getName();
        if (name == null) {
            return Collections.emptyList();
        }
        ArrayList<PyFunction> result = new ArrayList<PyFunction>();
        for (PyClass aClass : pyClass.getAncestorClasses()) {
            PyFunction byName = aClass.findMethodByName(name, false);
            if (byName == null) continue;
            result.add(byName);
        }
        return result;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

