/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.LightNamedElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDunderAllReference
extends PsiReferenceBase<PyStringLiteralExpression> {
    public PyDunderAllReference(@NotNull PyStringLiteralExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/PyDunderAllReference", "<init>"));
        }
        super((PsiElement)element);
        List<TextRange> ranges = element.getStringValueTextRanges();
        if (!ranges.isEmpty()) {
            this.setRangeInElement(ranges.get(0));
        }
    }

    public PsiElement resolve() {
        PyStringLiteralExpression element = (PyStringLiteralExpression)this.getElement();
        String name = element.getStringValue();
        PyFile containingFile = (PyFile)element.getContainingFile();
        return containingFile.getElementNamed(name);
    }

    @NotNull
    public Object[] getVariants() {
        final ArrayList result = new ArrayList();
        PyFile containingFile = (PyFile)((PyStringLiteralExpression)this.getElement()).getContainingFile().getOriginalFile();
        List<String> dunderAll = containingFile.getDunderAll();
        final HashSet<String> seenNames = new HashSet<String>();
        if (dunderAll != null) {
            seenNames.addAll(dunderAll);
        }
        containingFile.processDeclarations(new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
                String visibleName;
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/PyDunderAllReference$1", "execute"));
                }
                if (state2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/python/codeInsight/PyDunderAllReference$1", "execute"));
                }
                if (element instanceof PsiNamedElement && !(element instanceof LightNamedElement)) {
                    String name = ((PsiNamedElement)element).getName();
                    if (name != null && PyUtil.getInitialUnderscores(name) == 0 && !seenNames.contains(name)) {
                        seenNames.add(name);
                        result.add(LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)element)).withIcon(element.getIcon(0)));
                    }
                } else if (element instanceof PyImportElement && (visibleName = ((PyImportElement)element).getVisibleName()) != null && !seenNames.contains(visibleName)) {
                    seenNames.add(visibleName);
                    result.add(LookupElementBuilder.create((Object)element, (String)visibleName));
                }
                return true;
            }

            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/jetbrains/python/codeInsight/PyDunderAllReference$1", "getHint"));
                }
                return null;
            }

            public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/codeInsight/PyDunderAllReference$1", "handleEvent"));
                }
            }
        }, ResolveState.initial(), null, containingFile);
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyDunderAllReference", "getVariants"));
        }
        return objectArray;
    }
}

