/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import org.jetbrains.annotations.NotNull;

public class PyDeclarationRangeHandler
implements DeclarationRangeHandler {
    @NotNull
    public TextRange getDeclarationRange(@NotNull PsiElement container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/python/codeInsight/PyDeclarationRangeHandler", "getDeclarationRange"));
        }
        int start = container.getTextRange().getStartOffset();
        if (container instanceof PyFunction) {
            PyParameterList parameterList = ((PyFunction)container).getParameterList();
            TextRange textRange = new TextRange(start, parameterList.getTextRange().getEndOffset());
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyDeclarationRangeHandler", "getDeclarationRange"));
            }
            return textRange;
        }
        if (container instanceof PyClass) {
            PyArgumentList argumentList = ((PyClass)container).getSuperClassExpressionList();
            if (argumentList != null) {
                TextRange textRange = new TextRange(start, argumentList.getTextRange().getEndOffset());
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyDeclarationRangeHandler", "getDeclarationRange"));
                }
                return textRange;
            }
            ASTNode nameNode = ((PyClass)container).getNameNode();
            if (nameNode != null) {
                TextRange textRange = new TextRange(start, nameNode.getStartOffset() + nameNode.getTextLength());
                if (textRange == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyDeclarationRangeHandler", "getDeclarationRange"));
                }
                return textRange;
            }
        }
        TextRange textRange = container.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyDeclarationRangeHandler", "getDeclarationRange"));
        }
        return textRange;
    }
}

