/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.jetbrains.python.codeInsight.PyPsiPath;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCustomMember {
    private String myName;
    private final boolean myResolveToInstance;
    private final Function<PsiElement, PyType> myTypeCallback;
    @Nullable
    private final String myTypeName;
    private final PsiElement myTarget;
    private PyPsiPath myPsiPath;
    boolean myFunction;
    private boolean myAlwaysResolveToCustomElement;

    public PyCustomMember(@NotNull String name, @Nullable String type, boolean resolveToInstance) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/PyCustomMember", "<init>"));
        }
        this.myFunction = false;
        this.myName = name;
        this.myResolveToInstance = resolveToInstance;
        this.myTypeName = type;
        this.myTarget = null;
        this.myTypeCallback = null;
    }

    public PyCustomMember(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/PyCustomMember", "<init>"));
        }
        this.myFunction = false;
        this.myName = name;
        this.myResolveToInstance = false;
        this.myTypeName = null;
        this.myTarget = null;
        this.myTypeCallback = null;
    }

    public PyCustomMember(@NotNull String name, @Nullable String type, Function<PsiElement, PyType> typeCallback) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/PyCustomMember", "<init>"));
        }
        this.myFunction = false;
        this.myName = name;
        this.myResolveToInstance = false;
        this.myTypeName = type;
        this.myTarget = null;
        this.myTypeCallback = typeCallback;
    }

    public PyCustomMember(@NotNull String name, @Nullable PsiElement target, @Nullable String typeName) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/PyCustomMember", "<init>"));
        }
        this.myFunction = false;
        this.myName = name;
        this.myTarget = target;
        this.myResolveToInstance = false;
        this.myTypeName = typeName;
        this.myTypeCallback = null;
    }

    public PyCustomMember(@NotNull String name, @Nullable PsiElement target) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/codeInsight/PyCustomMember", "<init>"));
        }
        this(name, target, null);
    }

    public PyCustomMember resolvesTo(String moduleQName) {
        this.myPsiPath = new PyPsiPath.ToFile(moduleQName);
        return this;
    }

    public PyCustomMember resolvesToClass(String classQName) {
        this.myPsiPath = new PyPsiPath.ToClassQName(classQName);
        return this;
    }

    @NotNull
    public final PyCustomMember alwaysResolveToCustomElement() {
        this.myAlwaysResolveToCustomElement = true;
        PyCustomMember pyCustomMember = this;
        if (pyCustomMember == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/codeInsight/PyCustomMember", "alwaysResolveToCustomElement"));
        }
        return pyCustomMember;
    }

    public PyCustomMember toClass(String name) {
        this.myPsiPath = new PyPsiPath.ToClass(this.myPsiPath, name);
        return this;
    }

    public PyCustomMember toFunction(String name) {
        this.myPsiPath = new PyPsiPath.ToFunction(this.myPsiPath, name);
        return this;
    }

    public PyCustomMember toFunctionRecursive(String name) {
        this.myPsiPath = new PyPsiPath.ToFunctionRecursive(this.myPsiPath, name);
        return this;
    }

    public PyCustomMember toClassAttribute(String name) {
        this.myPsiPath = new PyPsiPath.ToClassAttribute(this.myPsiPath, name);
        return this;
    }

    public PyCustomMember toCall(String name, String ... args) {
        this.myPsiPath = new PyPsiPath.ToCall(this.myPsiPath, name, args);
        return this;
    }

    public PyCustomMember toAssignment(String assignee) {
        this.myPsiPath = new PyPsiPath.ToAssignment(this.myPsiPath, assignee);
        return this;
    }

    public PyCustomMember toPsiElement(final PsiElement psiElement) {
        this.myPsiPath = new PyPsiPath(){

            @Override
            public PsiElement resolve(PsiElement module) {
                return psiElement;
            }
        };
        return this;
    }

    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        if (this.myTarget != null) {
            return this.myTarget.getIcon(0);
        }
        return AllIcons.Nodes.Method;
    }

    @Nullable
    public PsiElement resolve(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyCustomMember", "resolve"));
        }
        if (this.myTarget != null) {
            return this.myTarget;
        }
        PyClass targetClass = this.myTypeName != null && this.myTypeName.indexOf(46) > 0 ? PyPsiFacade.getInstance(context.getProject()).findClass(this.myTypeName) : null;
        PsiElement resolveTarget = this.findResolveTarget(context);
        if (resolveTarget instanceof PyFunction && !this.myAlwaysResolveToCustomElement) {
            return resolveTarget;
        }
        if (resolveTarget != null || targetClass != null) {
            return new MyInstanceElement(targetClass, context, resolveTarget);
        }
        return null;
    }

    @Nullable
    private PsiElement findResolveTarget(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyCustomMember", "findResolveTarget"));
        }
        if (this.myPsiPath != null) {
            return this.myPsiPath.resolve(context);
        }
        return null;
    }

    @Nullable
    public String getShortType() {
        if (this.myTypeName == null) {
            return null;
        }
        int pos = this.myTypeName.lastIndexOf(46);
        return this.myTypeName.substring(pos + 1);
    }

    public PyCustomMember asFunction() {
        this.myFunction = true;
        return this;
    }

    public boolean isFunction() {
        return this.myFunction;
    }

    private class MyInstanceElement
    extends ASTWrapperPsiElement
    implements PyTypedElement {
        private final PyClass myClass;
        private final PsiElement myContext;

        public MyInstanceElement(PyClass clazz, PsiElement context, PsiElement resolveTarget) {
            super(resolveTarget != null ? resolveTarget.getNode() : clazz.getNode());
            this.myClass = clazz;
            this.myContext = context;
        }

        @Override
        public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/codeInsight/PyCustomMember$MyInstanceElement", "getType"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/codeInsight/PyCustomMember$MyInstanceElement", "getType"));
            }
            if (PyCustomMember.this.myTypeCallback != null) {
                return (PyType)PyCustomMember.this.myTypeCallback.fun((Object)this.myContext);
            }
            if (this.myClass != null) {
                return PyPsiFacade.getInstance(this.getProject()).createClassType(this.myClass, !PyCustomMember.this.myResolveToInstance);
            }
            return null;
        }
    }
}

