/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.ContainerProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.jetbrains.python.psi.PyElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyContainerProvider
implements ContainerProvider {
    @Nullable
    public PsiElement getContainer(@NotNull PsiElement item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/python/codeInsight/PyContainerProvider", "getContainer"));
        }
        if (item instanceof PyElement && item instanceof StubBasedPsiElement) {
            return PyContainerProvider.getContainerByStub((StubBasedPsiElement)item);
        }
        return null;
    }

    @Nullable
    private static PsiElement getContainerByStub(@NotNull StubBasedPsiElement element) {
        StubElement parentStub;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/codeInsight/PyContainerProvider", "getContainerByStub"));
        }
        StubElement stub = element.getStub();
        if (stub != null && (parentStub = stub.getParentStub()) != null) {
            return parentStub.getPsi();
        }
        return null;
    }
}

