/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout.config.ref;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgFile;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgSection;
import com.jetbrains.python.psi.PyElementGenerator;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class BuildoutPartReference
extends PsiReferenceBase<PsiElement> {
    private final String myPartName;
    private final int myOffsetInElement;

    public BuildoutPartReference(PsiElement element, String partName, int offsetInElement) {
        super(element);
        this.myPartName = partName;
        this.myOffsetInElement = offsetInElement;
    }

    public TextRange getRangeInElement() {
        return TextRange.from((int)this.myOffsetInElement, (int)this.myPartName.length());
    }

    public PsiElement resolve() {
        BuildoutCfgFile file = (BuildoutCfgFile)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, BuildoutCfgFile.class);
        if (file != null) {
            return file.findSectionByName(this.myPartName);
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList res = Lists.newArrayList();
        BuildoutCfgFile file = (BuildoutCfgFile)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, BuildoutCfgFile.class);
        if (file != null) {
            for (BuildoutCfgSection sec : file.getSections()) {
                String name = sec.getHeaderName();
                if (name == null) continue;
                res.add(name);
            }
            Object[] objectArray = res.toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/config/ref/BuildoutPartReference", "getVariants"));
            }
            return objectArray;
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/config/ref/BuildoutPartReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) {
        if (newElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/jetbrains/python/buildout/config/ref/BuildoutPartReference", "handleElementRename"));
        }
        String fullName = PythonStringUtil.replaceLastSuffix(this.getElement().getText(), "/", newElementName);
        return this.myElement.replace((PsiElement)PyElementGenerator.getInstance(this.myElement.getProject()).createStringLiteralAlreadyEscaped(fullName));
    }
}

