/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout.config.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgFile;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgOption;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgSection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildoutPsiUtil {
    private static final String RECIPE = "recipe";
    private static final String DJANGO_RECIPE = "djangorecipe";

    @Nullable
    public static BuildoutCfgSection getDjangoSection(@NotNull BuildoutCfgFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/jetbrains/python/buildout/config/psi/BuildoutPsiUtil", "getDjangoSection"));
        }
        List<String> parts = configFile.getParts();
        for (String part : parts) {
            BuildoutCfgSection section = configFile.findSectionByName(part);
            if (section == null || !DJANGO_RECIPE.equals(section.getOptionValue(RECIPE))) continue;
            return section;
        }
        return null;
    }

    public static boolean isInBuildoutSection(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/buildout/config/psi/BuildoutPsiUtil", "isInBuildoutSection"));
        }
        BuildoutCfgSection section = (BuildoutCfgSection)PsiTreeUtil.getParentOfType((PsiElement)element, BuildoutCfgSection.class);
        return section != null && "buildout".equals(section.getHeaderName());
    }

    public static boolean isAssignedTo(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/buildout/config/psi/BuildoutPsiUtil", "isAssignedTo"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/buildout/config/psi/BuildoutPsiUtil", "isAssignedTo"));
        }
        BuildoutCfgOption option = (BuildoutCfgOption)PsiTreeUtil.getParentOfType((PsiElement)element, BuildoutCfgOption.class);
        return option != null && name.equals(option.getKey());
    }
}

