/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout.config.inspection;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.buildout.config.BuildoutCfgFileType;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgValueLine;
import com.jetbrains.python.buildout.config.ref.BuildoutPartReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BuildoutUnresolvedPartInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = PyBundle.message("buildout", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/config/inspection/BuildoutUnresolvedPartInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("buildout.unresolved.part.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/config/inspection/BuildoutUnresolvedPartInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("BuildoutUnresolvedPartInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/config/inspection/BuildoutUnresolvedPartInspection", "getShortName"));
        }
        return "BuildoutUnresolvedPartInspection";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/buildout/config/inspection/BuildoutUnresolvedPartInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/python/buildout/config/inspection/BuildoutUnresolvedPartInspection", "checkFile"));
        }
        ArrayList problems = Lists.newArrayList();
        if (file.getFileType().equals((Object)BuildoutCfgFileType.INSTANCE)) {
            Visitor visitor = new Visitor();
            file.accept((PsiElementVisitor)visitor);
            for (BuildoutPartReference ref : visitor.getUnresolvedParts()) {
                ProblemDescriptor d = manager.createProblemDescriptor(ref.getElement(), ref.getRangeInElement(), PyBundle.message("buildout.unresolved.part.inspection.msg", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
                problems.add(d);
            }
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private class Visitor
    extends PsiRecursiveElementVisitor {
        private final List<BuildoutPartReference> unresolvedParts = Lists.newArrayList();

        private Visitor() {
        }

        public void visitElement(PsiElement element) {
            if (element instanceof BuildoutCfgValueLine) {
                PsiReference[] refs;
                for (PsiReference ref : refs = element.getReferences()) {
                    if (!(ref instanceof BuildoutPartReference) || ref.resolve() != null) continue;
                    this.unresolvedParts.add((BuildoutPartReference)ref);
                }
            }
            super.visitElement(element);
        }

        public List<BuildoutPartReference> getUnresolvedParts() {
            return this.unresolvedParts;
        }
    }
}

