/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout;

import com.intellij.facet.FacetType;
import com.intellij.framework.detection.FacetBasedFrameworkDetector;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.buildout.BuildoutFacetConfiguration;
import com.jetbrains.python.buildout.BuildoutFacetType;
import com.jetbrains.python.buildout.config.BuildoutCfgFileType;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildoutFrameworkDetector
extends FacetBasedFrameworkDetector<BuildoutFacet, BuildoutFacetConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.buildout.BuildoutFrameworkDetector");

    public BuildoutFrameworkDetector() {
        super("buildout-python");
    }

    public FacetType<BuildoutFacet, BuildoutFacetConfiguration> getFacetType() {
        return BuildoutFacetType.getInstance();
    }

    @NotNull
    public FileType getFileType() {
        BuildoutCfgFileType buildoutCfgFileType = BuildoutCfgFileType.INSTANCE;
        if (buildoutCfgFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/BuildoutFrameworkDetector", "getFileType"));
        }
        return buildoutCfgFileType;
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        FileContentPattern fileContentPattern = FileContentPattern.fileContent();
        if (fileContentPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/BuildoutFrameworkDetector", "createSuitableFilePattern"));
        }
        return fileContentPattern;
    }

    @Nullable
    protected BuildoutFacetConfiguration createConfiguration(Collection<VirtualFile> files) {
        VirtualFile source = (VirtualFile)ContainerUtil.getFirstItem(files);
        LOG.info("Detecting Buildout facet for " + source.getPath());
        VirtualFile baseDir = source.getParent();
        VirtualFile runner = BuildoutFacet.getRunner(baseDir);
        if (runner != null) {
            File script = BuildoutFacet.findScript(null, "buildout", baseDir);
            if (script != null) {
                BuildoutFacetConfiguration configuration = new BuildoutFacetConfiguration(script.getName());
                configuration.setScriptName(script.getPath());
                VirtualFile scriptVFile = LocalFileSystem.getInstance().findFileByIoFile(script);
                if (scriptVFile != null) {
                    configuration.setPaths(BuildoutFacet.extractBuildoutPaths(scriptVFile));
                } else {
                    LOG.info("Could not find virtual file for buildout script " + script);
                }
                return configuration;
            }
            LOG.info("No buildout script found");
        } else {
            LOG.info("No runner script found");
        }
        return null;
    }
}

