/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.jetbrains.python.buildout.BuildoutFacet;
import com.jetbrains.python.buildout.BuildoutFacetConfiguration;
import com.jetbrains.python.buildout.BuildoutFacetType;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class BuildoutFacetConfigurator
implements DirectoryProjectConfigurator {
    @Override
    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        Module module;
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/python/buildout/BuildoutFacetConfigurator", "configureProject"));
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length > 0 && BuildoutFacet.getInstance(module = modules[0]) == null) {
            File script;
            baseDir.refresh(false, false);
            VirtualFile runner = BuildoutFacet.getRunner(baseDir);
            if (runner != null && (script = BuildoutFacet.findScript(null, "buildout", project.getBaseDir())) != null) {
                ProjectFacetManager facetManager = ProjectFacetManager.getInstance((Project)module.getProject());
                BuildoutFacetConfiguration config = (BuildoutFacetConfiguration)facetManager.createDefaultConfiguration((FacetType)BuildoutFacetType.getInstance());
                config.setScriptName(script.getPath());
                BuildoutFacetConfigurator.setupFacet(module, config);
            }
        }
    }

    static void setupFacet(Module module, @NotNull BuildoutFacetConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/python/buildout/BuildoutFacetConfigurator", "setupFacet"));
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module);
        final ModifiableFacetModel model = facetManager.createModifiableModel();
        BuildoutFacetType facetType = BuildoutFacetType.getInstance();
        BuildoutFacet facet = (BuildoutFacet)facetManager.createFacet((FacetType)facetType, facetType.getDefaultFacetName(), (FacetConfiguration)config, null);
        model.addFacet((Facet)facet);
        new WriteAction(){

            protected void run(Result result) throws Throwable {
                model.commit();
            }
        }.execute();
        facet.updatePaths();
        BuildoutFacet.attachLibrary(module);
    }
}

