/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.buildout.BuildoutFacetConfiguration;
import com.jetbrains.python.buildout.BuildoutFacetType;
import com.jetbrains.python.buildout.config.BuildoutCfgLanguage;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgFile;
import com.jetbrains.python.facet.FacetLibraryConfigurator;
import com.jetbrains.python.facet.LibraryContributingFacet;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildoutFacet
extends Facet<BuildoutFacetConfiguration>
implements PythonPathContributingFacet,
LibraryContributingFacet {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.buildout.BuildoutFacet");
    @NonNls
    public static final String BUILDOUT_CFG = "buildout.cfg";
    @NonNls
    public static final String SCRIPT_SUFFIX = "-script";
    private static final String BUILDOUT_LIB_NAME = "Buildout Eggs";

    public BuildoutFacet(@NotNull FacetType facetType, final @NotNull Module module, @NotNull String name, @NotNull BuildoutFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/jetbrains/python/buildout/BuildoutFacet", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/buildout/BuildoutFacet", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/buildout/BuildoutFacet", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/python/buildout/BuildoutFacet", "<init>"));
        }
        super(facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/buildout/BuildoutFacet$1", "contentsChanged"));
                }
                if (Comparing.equal((Object)event.getFile(), (Object)BuildoutFacet.this.getScript())) {
                    BuildoutFacet.this.updatePaths();
                    BuildoutFacet.attachLibrary(module);
                }
            }
        }, (Disposable)this);
    }

    @Nullable
    public static VirtualFile getRunner(VirtualFile baseDir) {
        VirtualFile bin;
        VirtualFile eggs;
        if (baseDir == null) {
            return null;
        }
        VirtualFile cfg = baseDir.findChild(BUILDOUT_CFG);
        if (cfg != null && !cfg.isDirectory() && (eggs = baseDir.findChild("eggs")) != null && eggs.isDirectory() && (bin = baseDir.findChild("bin")) != null && bin.isDirectory()) {
            String exe;
            VirtualFile runner;
            if (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) {
                bin.refresh(false, false);
            }
            if ((runner = bin.findChild(exe = SystemInfo.isWindows || SystemInfo.isOS2 ? "buildout.exe" : "buildout")) != null && !runner.isDirectory()) {
                return runner;
            }
        }
        return null;
    }

    @NotNull
    public static List<VirtualFile> getExtraPathForAllOpenModules() {
        ArrayList<VirtualFile> results = new ArrayList<VirtualFile>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                BuildoutFacet buildoutFacet = BuildoutFacet.getInstance(module);
                if (buildoutFacet == null) continue;
                for (String path : ((BuildoutFacetConfiguration)buildoutFacet.getConfiguration()).getPaths()) {
                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                    if (file == null) continue;
                    results.add(file);
                }
            }
        }
        ArrayList<VirtualFile> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/buildout/BuildoutFacet", "getExtraPathForAllOpenModules"));
        }
        return arrayList;
    }

    @Nullable
    public String getPathPrependStatement(List<String> additionalPythonPath) {
        StringBuilder sb = new StringBuilder("sys.path[0:0]=[");
        for (String s : additionalPythonPath) {
            sb.append("'").append(s).append("',");
        }
        sb.append("]");
        return sb.toString();
    }

    public void initFacet() {
        this.updateLibrary();
    }

    @Override
    public void updateLibrary() {
        this.updatePaths();
        BuildoutFacet.attachLibrary(this.getModule());
    }

    @Override
    public void removeLibrary() {
        BuildoutFacet.detachLibrary(this.getModule());
    }

    public void updatePaths() {
        BuildoutFacetConfiguration config = (BuildoutFacetConfiguration)this.getConfiguration();
        VirtualFile script = this.getScript();
        if (script != null) {
            config.setPaths(BuildoutFacet.extractBuildoutPaths(script));
        }
    }

    @Nullable
    public VirtualFile getScript() {
        return LocalFileSystem.getInstance().findFileByPath(((BuildoutFacetConfiguration)this.getConfiguration()).getScriptName());
    }

    @Nullable
    public static List<String> extractBuildoutPaths(@NotNull VirtualFile script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/python/buildout/BuildoutFacet", "extractBuildoutPaths"));
        }
        try {
            List<String> paths = BuildoutFacet.extractFromScript(script);
            if (paths == null) {
                VirtualFile sitePy;
                VirtualFile root = script.getParent().getParent();
                String partName = FileUtil.getNameWithoutExtension((String)script.getName());
                if (SystemInfo.isWindows && partName.endsWith(SCRIPT_SUFFIX)) {
                    partName = partName.substring(0, partName.length() - SCRIPT_SUFFIX.length());
                }
                if ((sitePy = root.findFileByRelativePath("parts/" + partName + "/site.py")) != null) {
                    paths = BuildoutFacet.extractFromSitePy(sitePy);
                }
            }
            return paths;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static List<String> extractFromScript(@NotNull VirtualFile script) throws IOException {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/python/buildout/BuildoutFacet", "extractFromScript"));
        }
        String text = VfsUtil.loadText((VirtualFile)script);
        Pattern pat = Pattern.compile("(?:^\\s*(['\"])(.*)(\\1),\\s*$)|(\\])", 8);
        String bait_string = "sys.path[0:0]";
        int pos = text.indexOf("sys.path[0:0]");
        ArrayList<String> ret = null;
        if (pos >= 0) {
            String value;
            pos += "sys.path[0:0]".length();
            Matcher scanner = pat.matcher(text);
            while (scanner.find(pos) && (value = scanner.group(2)) != null) {
                if (ret == null) {
                    ret = new ArrayList<String>();
                }
                ret.add(value);
                pos = scanner.end();
            }
        }
        return ret;
    }

    public static List<String> extractFromSitePy(VirtualFile vFile) throws IOException {
        int index;
        ArrayList<String> result = new ArrayList<String>();
        String text = VfsUtil.loadText((VirtualFile)vFile);
        String[] lines = LineTokenizer.tokenize((CharSequence)text, (boolean)false);
        for (index = 0; index < lines.length && !lines[index].startsWith("def addsitepackages("); ++index) {
        }
        while (index < lines.length && !lines[index].trim().startsWith("buildout_paths = [")) {
            ++index;
        }
        ++index;
        while (index < lines.length && !lines[index].trim().equals("]")) {
            String line = lines[index].trim();
            if (line.endsWith(",")) {
                line = line.substring(0, line.length() - 1);
            }
            if (line.startsWith("'") && line.endsWith("'")) {
                result.add(StringUtil.unescapeStringCharacters((String)line.substring(1, line.length() - 1)));
            }
            ++index;
        }
        return result;
    }

    @Override
    public List<String> getAdditionalPythonPath() {
        BuildoutFacetConfiguration cfg = (BuildoutFacetConfiguration)this.getConfiguration();
        return cfg.getPaths();
    }

    @Override
    public boolean acceptRootAsTopLevelPackage() {
        return false;
    }

    @Nullable
    public static BuildoutFacet getInstance(Module module) {
        return (BuildoutFacet)FacetManager.getInstance((Module)module).getFacetByType(BuildoutFacetType.ID);
    }

    public void patchCommandLineForBuildout(GeneralCommandLine commandLine) {
        Map env = commandLine.getEnvironment();
        ParametersList params = commandLine.getParametersList();
        ParamsGroup script_params = params.getParamsGroup("Script");
        assert (script_params != null);
        if (script_params.getParameters().size() > 0) {
            String normal_script = (String)script_params.getParameters().get(0);
            String engulfer_path = PythonHelpersLocator.getHelperPath("pycharm/buildout_engulfer.py");
            env.put("PYCHARM_ENGULF_SCRIPT", ((BuildoutFacetConfiguration)this.getConfiguration()).getScriptName());
            script_params.getParametersList().replaceOrPrepend(normal_script, engulfer_path);
        }
        PythonEnvUtil.addToPythonPath((Map<String, String>)env, PythonHelpersLocator.getHelpersRoot().getAbsolutePath());
    }

    @Nullable
    public File getConfigFile() {
        String scriptName = ((BuildoutFacetConfiguration)this.getConfiguration()).getScriptName();
        if (!StringUtil.isEmpty((String)scriptName)) {
            return new File(new File(scriptName).getParentFile().getParentFile(), BUILDOUT_CFG);
        }
        return null;
    }

    @Nullable
    public BuildoutCfgFile getConfigPsiFile() {
        File cfg = this.getConfigFile();
        if (cfg != null && cfg.exists()) {
            try {
                String text = FileUtil.loadFile((File)cfg);
                PsiFile configFile = PsiFileFactory.getInstance((Project)this.getModule().getProject()).createFileFromText(BUILDOUT_CFG, (Language)BuildoutCfgLanguage.INSTANCE, (CharSequence)text);
                if (configFile != null && configFile instanceof BuildoutCfgFile) {
                    return (BuildoutCfgFile)configFile;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<File> getScripts(@Nullable BuildoutFacet buildoutFacet, VirtualFile baseDir) {
        File[] scripts;
        File configIOFile;
        File rootPath = null;
        if (buildoutFacet != null && (configIOFile = buildoutFacet.getConfigFile()) != null) {
            rootPath = configIOFile.getParentFile();
        }
        if (!(rootPath != null && rootPath.exists() || baseDir == null)) {
            rootPath = new File(baseDir.getPath());
        }
        if (rootPath != null && (scripts = new File(rootPath, "bin").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (SystemInfo.isWindows) {
                    return name.endsWith("-script.py");
                }
                String ext = FileUtilRt.getExtension((String)name);
                return ext.length() == 0 || FileUtil.namesEqual((String)ext, (String)"py");
            }
        })) != null) {
            return Arrays.asList(scripts);
        }
        return Collections.emptyList();
    }

    @Nullable
    public static File findScript(@Nullable BuildoutFacet buildoutFacet, String name, VirtualFile baseDir) {
        String scriptName = SystemInfo.isWindows ? name + SCRIPT_SUFFIX : name;
        List<File> scripts = BuildoutFacet.getScripts(buildoutFacet, baseDir);
        for (File script : scripts) {
            if (!FileUtil.getNameWithoutExtension((String)script.getName()).equals(scriptName)) continue;
            return script;
        }
        return null;
    }

    public static void attachLibrary(Module module) {
        BuildoutFacet facet = BuildoutFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        List<String> paths = ((BuildoutFacetConfiguration)facet.getConfiguration()).getPaths();
        FacetLibraryConfigurator.attachPythonLibrary(module, null, BUILDOUT_LIB_NAME, paths);
    }

    public static void detachLibrary(Module module) {
        FacetLibraryConfigurator.detachPythonLibrary(module, BUILDOUT_LIB_NAME);
    }
}

