/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import org.jetbrains.annotations.Nullable;

public class PyQualifiedNameProvider
implements QualifiedNameProvider {
    @Override
    public PsiElement adjustElementToCopy(PsiElement element) {
        return element instanceof PyClass || element instanceof PyFunction ? element : null;
    }

    @Override
    @Nullable
    public String getQualifiedName(PsiElement element) {
        PyClass containingClass;
        if (element instanceof PyClass) {
            return ((PyClass)element).getQualifiedName();
        }
        if (element instanceof PyFunction && (containingClass = ((PyFunction)element).getContainingClass()) != null) {
            return containingClass.getQualifiedName() + "#" + ((PyFunction)element).getName();
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement qualifiedNameToElement(String fqn, Project project) {
        String className;
        PyClass aClass = PyClassNameIndex.findClass(fqn, project);
        if (aClass != null) {
            return aClass;
        }
        int sharpIdx = fqn.indexOf("#");
        if (sharpIdx > -1 && (aClass = PyClassNameIndex.findClass(className = StringUtil.getPackageName((String)fqn, (char)'#'), project)) != null) {
            String memberName = StringUtil.getShortName((String)fqn, (char)'#');
            PyClass nestedClass = aClass.findNestedClass(memberName, false);
            if (nestedClass != null) {
                return nestedClass;
            }
            PyFunction methodByName = aClass.findMethodByName(memberName, false);
            if (methodByName != null) {
                return methodByName;
            }
        }
        return null;
    }

    @Override
    public void insertQualifiedName(String fqn, PsiElement element, Editor editor, Project project) {
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)fqn);
    }
}

