/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.codeInsight.editorActions.fillParagraph.ParagraphFillHandler;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFillParagraphHandler
extends ParagraphFillHandler {
    @Override
    @NotNull
    protected String getPrefix(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPrefix"));
        }
        PyStringLiteralExpression stringLiteralExpression = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyStringLiteralExpression.class);
        if (stringLiteralExpression != null) {
            String text = stringLiteralExpression.getText();
            Pair<String, String> quotes = PythonStringUtil.getQuotes(text);
            PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)stringLiteralExpression, PyDocStringOwner.class);
            if (docStringOwner != null && stringLiteralExpression.equals(docStringOwner.getDocStringExpression())) {
                String indent = PyFillParagraphHandler.getIndent(stringLiteralExpression);
                if (quotes != null) {
                    List strings = StringUtil.split((String)text, (String)"\n");
                    if (((String)strings.get(0)).trim().equals(quotes.getFirst())) {
                        String string = (String)quotes.getFirst() + indent;
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPrefix"));
                        }
                        return string;
                    }
                    String value = stringLiteralExpression.getStringValue();
                    int firstNotSpace = StringUtil.findFirst((CharSequence)value, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
                    String string = (String)quotes.getFirst() + value.substring(0, firstNotSpace);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPrefix"));
                    }
                    return string;
                }
                String string = "\"" + indent;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPrefix"));
                }
                return string;
            }
            String string = quotes != null ? (String)quotes.getFirst() : "\"";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPrefix"));
            }
            return string;
        }
        String string = element instanceof PsiComment ? "# " : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPrefix"));
        }
        return string;
    }

    private static String getIndent(PyStringLiteralExpression stringLiteralExpression) {
        PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)stringLiteralExpression, PyStatementList.class);
        String indent = "";
        if (statementList != null) {
            PsiElement whiteSpace = statementList.getPrevSibling();
            indent = whiteSpace instanceof PsiWhiteSpace ? whiteSpace.getText() : "\n";
        }
        return indent;
    }

    @Override
    @NotNull
    protected String getPostfix(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPostfix"));
        }
        PyStringLiteralExpression stringLiteralExpression = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyStringLiteralExpression.class);
        if (stringLiteralExpression != null) {
            String text = stringLiteralExpression.getText();
            Pair<String, String> quotes = PythonStringUtil.getQuotes(text);
            PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)stringLiteralExpression, PyDocStringOwner.class);
            if (docStringOwner != null && stringLiteralExpression.equals(docStringOwner.getDocStringExpression())) {
                String indent = PyFillParagraphHandler.getIndent(stringLiteralExpression);
                if (quotes != null) {
                    List strings = StringUtil.split((String)text, (String)"\n");
                    if (((String)strings.get(strings.size() - 1)).trim().equals(quotes.getSecond())) {
                        String string = indent + (String)quotes.getSecond();
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPostfix"));
                        }
                        return string;
                    }
                    String string = (String)quotes.getSecond();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPostfix"));
                    }
                    return string;
                }
                String string = indent + "\"";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPostfix"));
                }
                return string;
            }
            String string = quotes != null ? (String)quotes.getSecond() : "\"";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPostfix"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyFillParagraphHandler", "getPostfix"));
        }
        return "";
    }

    @Override
    protected boolean isAvailableForElement(@Nullable PsiElement element) {
        if (element != null) {
            PyStringLiteralExpression stringLiteral = (PyStringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyStringLiteralExpression.class);
            return stringLiteral != null || element instanceof PsiComment;
        }
        return false;
    }

    @Override
    protected boolean isAvailableForFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof PyFile;
    }
}

