/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.psi.PyFile;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExecuteSelectionAction
extends AnAction {
    public static final String EXECUTE_SELECTION_IN_CONSOLE = "Execute Selection in Console";

    public PyExecuteSelectionAction() {
        super(EXECUTE_SELECTION_IN_CONSOLE);
    }

    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor != null) {
            String selectionText = PyExecuteSelectionAction.getSelectionText(editor);
            if (selectionText != null) {
                PyExecuteSelectionAction.execute(e, selectionText);
            } else {
                String line = PyExecuteSelectionAction.getLineUnderCaret(editor);
                if (line != null) {
                    PyExecuteSelectionAction.execute(e, line);
                    PyExecuteSelectionAction.moveCaretDown(editor);
                }
            }
        }
    }

    private static void moveCaretDown(Editor editor) {
        VisualPosition pos = editor.getCaretModel().getVisualPosition();
        Pair<LogicalPosition, LogicalPosition> lines = EditorUtil.calcSurroundingRange(editor, pos, pos);
        int offset = editor.getCaretModel().getOffset();
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        Document document = editor.getDocument();
        if (nextLineStart.line < document.getLineCount()) {
            int newOffset = end + offset - start;
            int nextLineEndOffset = document.getLineEndOffset(nextLineStart.line);
            if (newOffset >= nextLineEndOffset) {
                newOffset = nextLineEndOffset;
            }
            editor.getCaretModel().moveToOffset(newOffset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static void execute(AnActionEvent e, final String selectionText) {
        final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        PyExecuteSelectionAction.findCodeExecutor(e, new Consumer<PyCodeExecutor>(){

            public void consume(PyCodeExecutor codeExecutor) {
                PyExecuteSelectionAction.executeInConsole(codeExecutor, selectionText, editor);
            }
        }, editor, project, module);
    }

    private static String getLineUnderCaret(Editor editor) {
        VisualPosition caretPos = editor.getCaretModel().getVisualPosition();
        Pair<LogicalPosition, LogicalPosition> lines = EditorUtil.calcSurroundingRange(editor, caretPos, caretPos);
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        if (end <= start) {
            return null;
        }
        return ((Object)editor.getDocument().getCharsSequence().subSequence(start, end)).toString();
    }

    @Nullable
    private static String getSelectionText(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/python/actions/PyExecuteSelectionAction", "getSelectionText"));
        }
        if (editor.getSelectionModel().hasSelection()) {
            SelectionModel model = editor.getSelectionModel();
            return model.getSelectedText();
        }
        return null;
    }

    public void update(AnActionEvent e) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        Presentation presentation = e.getPresentation();
        boolean enabled = false;
        if (editor != null && PyExecuteSelectionAction.isPython(editor)) {
            String text = PyExecuteSelectionAction.getSelectionText(editor);
            if (text != null) {
                presentation.setText(EXECUTE_SELECTION_IN_CONSOLE);
            } else {
                text = PyExecuteSelectionAction.getLineUnderCaret(editor);
                if (text != null) {
                    presentation.setText("Execute Line in Console");
                }
            }
            enabled = !StringUtil.isEmpty((String)text);
        }
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    private static boolean isPython(Editor editor) {
        if (editor == null) {
            return false;
        }
        Project project = editor.getProject();
        if (project == null) {
            return false;
        }
        PsiFile psi = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return psi instanceof PyFile;
    }

    private static void selectConsole(@NotNull DataContext dataContext, @NotNull Project project, final Consumer<PyCodeExecutor> consumer) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/python/actions/PyExecuteSelectionAction", "selectConsole"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/actions/PyExecuteSelectionAction", "selectConsole"));
        }
        Collection<RunContentDescriptor> consoles = PyExecuteSelectionAction.getConsoles(project);
        ExecutionHelper.selectContentDescriptor(dataContext, project, consoles, "Select console to execute in", new Consumer<RunContentDescriptor>(){

            public void consume(RunContentDescriptor descriptor) {
                if (descriptor != null && descriptor.getExecutionConsole() instanceof PyCodeExecutor) {
                    consumer.consume((Object)((PyCodeExecutor)descriptor.getExecutionConsole()));
                }
            }
        });
    }

    private static Collection<RunContentDescriptor> getConsoles(Project project) {
        PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(project);
        if (toolWindow != null && toolWindow.getToolWindow().isVisible()) {
            RunContentDescriptor selectedContentDescriptor = toolWindow.getSelectedContentDescriptor();
            return selectedContentDescriptor != null ? Lists.newArrayList((Object[])new RunContentDescriptor[]{selectedContentDescriptor}) : Lists.newArrayList();
        }
        Collection<RunContentDescriptor> descriptors = ExecutionHelper.findRunningConsole(project, new NotNullFunction<RunContentDescriptor, Boolean>(){

            @NotNull
            public Boolean fun(RunContentDescriptor dom) {
                Boolean bl = dom.getExecutionConsole() instanceof PyCodeExecutor && PyExecuteSelectionAction.isAlive(dom);
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/actions/PyExecuteSelectionAction$3", "fun"));
                }
                return bl;
            }
        });
        if (descriptors.isEmpty() && toolWindow != null) {
            return toolWindow.getConsoleContentDescriptors();
        }
        return descriptors;
    }

    private static boolean isAlive(RunContentDescriptor dom) {
        ProcessHandler processHandler = dom.getProcessHandler();
        return processHandler != null && !processHandler.isProcessTerminated();
    }

    private static void findCodeExecutor(AnActionEvent e, Consumer<PyCodeExecutor> consumer, Editor editor, Project project, Module module) {
        if (project != null && editor != null) {
            if (PyExecuteSelectionAction.canFindConsole(e)) {
                PyExecuteSelectionAction.selectConsole(e.getDataContext(), project, consumer);
            } else {
                PyExecuteSelectionAction.startConsole(project, consumer, module);
            }
        }
    }

    private static void startConsole(Project project, final Consumer<PyCodeExecutor> consumer, Module context) {
        final PythonConsoleToolWindow toolWindow = PythonConsoleToolWindow.getInstance(project);
        if (toolWindow != null) {
            toolWindow.activate(new Runnable(){

                @Override
                public void run() {
                    List<RunContentDescriptor> descs = toolWindow.getConsoleContentDescriptors();
                    RunContentDescriptor descriptor = descs.get(0);
                    if (descriptor != null && descriptor.getExecutionConsole() instanceof PyCodeExecutor) {
                        consumer.consume((Object)((PyCodeExecutor)descriptor.getExecutionConsole()));
                    }
                }
            });
        } else {
            PythonConsoleRunnerFactory consoleRunnerFactory = PythonConsoleRunnerFactory.getInstance();
            PydevConsoleRunner runner = consoleRunnerFactory.createConsoleRunner(project, null);
            runner.addConsoleListener(new PydevConsoleRunner.ConsoleListener(){

                @Override
                public void handleConsoleInitialized(LanguageConsoleView consoleView) {
                    if (consoleView instanceof PyCodeExecutor) {
                        consumer.consume((Object)((PyCodeExecutor)((Object)consoleView)));
                    }
                }
            });
            runner.run();
        }
    }

    private static boolean canFindConsole(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project != null) {
            Collection<RunContentDescriptor> descriptors = PyExecuteSelectionAction.getConsoles(project);
            return descriptors.size() > 0;
        }
        return false;
    }

    private static void executeInConsole(@NotNull PyCodeExecutor codeExecutor, @NotNull String text, Editor editor) {
        if (codeExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeExecutor", "com/jetbrains/python/actions/PyExecuteSelectionAction", "executeInConsole"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/actions/PyExecuteSelectionAction", "executeInConsole"));
        }
        codeExecutor.executeCode(text, editor);
    }
}

