/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateDirectoryOrPackageHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import javax.swing.Icon;

public class CreatePackageAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.actions.CreatePackageAction");

    public void actionPerformed(AnActionEvent e) {
        IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (view == null) {
            return;
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final PsiDirectory directory = DirectoryChooserUtil.getOrChooseDirectory(view);
        if (directory == null) {
            return;
        }
        CreateDirectoryOrPackageHandler validator = new CreateDirectoryOrPackageHandler(project, directory, false, "."){

            @Override
            protected void createDirectories(String subDirName) {
                super.createDirectories(subDirName);
                PsiFileSystemItem element = this.getCreatedElement();
                if (element instanceof PsiDirectory) {
                    CreatePackageAction.createInitPyInHierarchy((PsiDirectory)element, directory);
                }
            }
        };
        Messages.showInputDialog((Project)project, (String)IdeBundle.message((String)"prompt.enter.new.package.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.package", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        PsiFileSystemItem result = validator.getCreatedElement();
        if (result != null) {
            view.selectElement((PsiElement)result);
        }
    }

    public static void createInitPyInHierarchy(PsiDirectory created, PsiDirectory ancestor) {
        do {
            CreatePackageAction.createInitPy(created);
        } while ((created = created.getParent()) != null && created != ancestor);
    }

    private static void createInitPy(PsiDirectory directory) {
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance();
        FileTemplate template = fileTemplateManager.getInternalTemplate("Python Script");
        if (directory.findFile("__init__.py") != null) {
            return;
        }
        if (template != null) {
            try {
                FileTemplateUtil.createFromTemplate(template, "__init__.py", fileTemplateManager.getDefaultProperties(directory.getProject()), directory);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        } else {
            PsiFile file = PsiFileFactory.getInstance((Project)directory.getProject()).createFileFromText("__init__.py", "");
            directory.add((PsiElement)file);
        }
    }

    public void update(AnActionEvent e) {
        boolean enabled = CreatePackageAction.isEnabled(e);
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
    }

    private static boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        IdeView ideView = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
        if (project == null || ideView == null) {
            return false;
        }
        PsiDirectory[] directories = ideView.getDirectories();
        return directories.length != 0;
    }
}

