/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CleanPycAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        final PsiElement[] elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
        if (elements == null) {
            return;
        }
        final ArrayList pycFiles = new ArrayList();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                for (PsiElement element : elements) {
                    PsiDirectory dir = (PsiDirectory)element;
                    CleanPycAction.collectPycFiles(new File(dir.getVirtualFile().getPath()), pycFiles);
                }
                FileUtil.asyncDelete((Collection)pycFiles);
            }
        }, "Cleaning up .pyc files...", false, e.getProject());
        StatusBar statusBar = WindowManager.getInstance().getIdeFrame(e.getProject()).getStatusBar();
        statusBar.setInfo("Deleted " + pycFiles.size() + " bytecode file" + (pycFiles.size() != 1 ? "s" : ""));
    }

    private static void collectPycFiles(File directory, final List<File> pycFiles) {
        FileUtil.processFilesRecursively((File)directory, (Processor)new Processor<File>(){

            public boolean process(File file) {
                if (file.getParentFile().getName().equals("__pycache__") || FileUtilRt.extensionEquals((String)file.getName(), (String)"pyc") || FileUtilRt.extensionEquals((String)file.getName(), (String)"pyo") || file.getName().endsWith("$py.class")) {
                    pycFiles.add(file);
                }
                return true;
            }
        });
    }

    public void update(AnActionEvent e) {
        PsiElement[] elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
        e.getPresentation().setEnabled(CleanPycAction.isAllDirectories(elements));
    }

    private static boolean isAllDirectories(@Nullable PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            if (element instanceof PsiDirectory && !FileIndexFacade.getInstance((Project)element.getProject()).isInLibraryClasses(((PsiDirectory)element).getVirtualFile())) continue;
            return false;
        }
        return true;
    }
}

