/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonStringUtil {
    private static final ImmutableList<String> QUOTES = ImmutableList.of((Object)"'''", (Object)"\"\"\"", (Object)"'", (Object)"\"");

    private PythonStringUtil() {
    }

    @NotNull
    public static String getStringValue(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/PythonStringUtil", "getStringValue"));
        }
        String string = PythonStringUtil.getStringValueTextRange(s).substring(s);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonStringUtil", "getStringValue"));
        }
        return string;
    }

    public static TextRange getStringValueTextRange(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/PythonStringUtil", "getStringValueTextRange"));
        }
        Pair<String, String> quotes = PythonStringUtil.getQuotes(s);
        if (quotes != null) {
            return TextRange.create((int)((String)quotes.getFirst()).length(), (int)(s.length() - ((String)quotes.getSecond()).length()));
        }
        return TextRange.allOf((String)s);
    }

    @NotNull
    public static String removeFirstPrefix(@Nullable String s, String separator) {
        int pos;
        if (s != null && (pos = s.indexOf(separator)) != -1) {
            String string = s.substring(pos + separator.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonStringUtil", "removeFirstPrefix"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonStringUtil", "removeFirstPrefix"));
        }
        return "";
    }

    @NotNull
    public static String removeLastSuffix(@Nullable String s, String separator) {
        int pos;
        if (s != null && (pos = s.lastIndexOf(separator)) != -1) {
            String string = s.substring(0, pos);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonStringUtil", "removeLastSuffix"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonStringUtil", "removeLastSuffix"));
        }
        return "";
    }

    public static boolean isPath(@Nullable String s) {
        if (!StringUtil.isEmpty((String)s)) {
            s = (String)ObjectUtils.assertNotNull((Object)s);
            s = FileUtil.toSystemIndependentName((String)s);
            List components = StringUtil.split((String)s, (String)"/");
            for (String name : components) {
                if (name == components.get(0) && SystemInfo.isWindows && name.endsWith(":") || PathUtil.isValidFileName((String)name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmail(String s) {
        if (!StringUtil.isEmpty((String)s)) {
            Pattern p = Pattern.compile("^[\\w\\.-]+@([\\w\\-]+\\.)+[a-z]{2,4}$");
            Matcher m = p.matcher(s);
            return m.matches();
        }
        return false;
    }

    @NotNull
    public static String getFirstPrefix(String s, String separator) {
        int pos;
        if (s != null && (pos = s.indexOf(separator)) != -1) {
            String string = s.substring(0, pos);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonStringUtil", "getFirstPrefix"));
            }
            return string;
        }
        String string = s != null ? s : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonStringUtil", "getFirstPrefix"));
        }
        return string;
    }

    public static String getLastSuffix(String s, String separator) {
        int pos;
        if (s != null && (pos = s.lastIndexOf(separator)) != -1) {
            return s.substring(pos + 1);
        }
        return "";
    }

    public static String replaceLastSuffix(String s, String separator, String newElementName) {
        Pair<String, String> quotes = null;
        if (PythonStringUtil.isQuoted(s)) {
            quotes = PythonStringUtil.getQuotes(s);
            s = PythonStringUtil.stripQuotesAroundValue(s);
        }
        if ((s = PythonStringUtil.removeLastSuffix(s, separator)).length() > 0) {
            s = s + separator;
        }
        s = s + newElementName;
        if (quotes != null) {
            s = (String)quotes.first + s + (String)quotes.second;
        }
        return s;
    }

    public static TextRange lastSuffixTextRange(@NotNull String text, String separator) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/PythonStringUtil", "lastSuffixTextRange"));
        }
        int offset = text.lastIndexOf(separator) + 1;
        int length = text.length() - offset;
        return TextRange.from((int)(offset + 1), (int)length);
    }

    public static boolean isQuoted(@Nullable String text) {
        return text != null && PythonStringUtil.getQuotes(text) != null;
    }

    @Nullable
    public static Pair<String, String> getQuotes(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/PythonStringUtil", "getQuotes"));
        }
        boolean start = true;
        int pos = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = Character.toLowerCase(text.charAt(i));
            if (!start) break;
            if (c == 'u' || c == 'r' || c == 'b') {
                pos = i + 1;
                continue;
            }
            start = false;
        }
        String prefix = text.substring(0, pos);
        String mainText = text.substring(pos);
        for (String quote : QUOTES) {
            Pair<String, String> quotes = PythonStringUtil.getQuotes(mainText, prefix, quote);
            if (quotes == null) continue;
            return quotes;
        }
        return null;
    }

    @Nullable
    private static Pair<String, String> getQuotes(@NotNull String text, @NotNull String prefix, @NotNull String quote) {
        int n;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/python/PythonStringUtil", "getQuotes"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/python/PythonStringUtil", "getQuotes"));
        }
        if (quote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quote", "com/jetbrains/python/PythonStringUtil", "getQuotes"));
        }
        int length = text.length();
        if (length >= 2 * (n = quote.length()) && text.startsWith(quote) && text.endsWith(quote)) {
            return Pair.create((Object)(prefix + text.substring(0, n)), (Object)text.substring(length - n));
        }
        return null;
    }

    @Nullable
    public static String intersect(String fullName, String elementStringValue) {
        QualifiedName fullQName = QualifiedName.fromDottedString((String)fullName);
        QualifiedName stringQName = QualifiedName.fromDottedString((String)elementStringValue);
        String[] s1 = stringQName.getComponents().toArray(new String[stringQName.getComponentCount()]);
        String[] s2 = fullQName.getComponents().toArray(new String[fullQName.getComponentCount()]);
        for (int i = s1.length - 1; i >= 0; --i) {
            boolean flag = true;
            if (i > s2.length - 1) continue;
            for (int j = 0; j <= i; ++j) {
                if (s1[i - j].equals(s2[s2.length - j - 1])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            StringBuilder res = new StringBuilder("");
            for (int j = 0; j <= i; ++j) {
                if (j > 0) {
                    res.append(".");
                }
                res.append(s1[j]);
            }
            return res.toString();
        }
        return null;
    }

    public static TextRange getTextRange(PsiElement element) {
        if (element instanceof PyStringLiteralExpression) {
            List<TextRange> ranges = ((PyStringLiteralExpression)element).getStringValueTextRanges();
            return ranges.get(0);
        }
        return new TextRange(0, element.getTextLength());
    }

    @Nullable
    public static String getText(@Nullable PyExpression ex) {
        if (ex == null) {
            return null;
        }
        return ex.getText();
    }

    @Nullable
    public static String getStringValue(@Nullable PsiElement o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression literalExpression = (PyStringLiteralExpression)o;
            return literalExpression.getStringValue();
        }
        return o.getText();
    }

    public static String stripQuotesAroundValue(String text) {
        Pair<String, String> quotes = PythonStringUtil.getQuotes(text);
        if (quotes == null) {
            return text;
        }
        return text.substring(((String)quotes.first).length(), text.length() - ((String)quotes.second).length());
    }

    public static boolean isRawString(String text) {
        if ((text = text.toLowerCase()).startsWith("u")) {
            text = text.substring(1);
        }
        return PythonStringUtil.isStringPrefixedBy(text.toLowerCase(), "r");
    }

    private static boolean isStringPrefixedBy(String text, String prefix) {
        return StringUtil.startsWith((CharSequence)text, (CharSequence)(prefix + "\"")) && StringUtil.endsWith((CharSequence)text, (CharSequence)"\"") || StringUtil.startsWith((CharSequence)text, (CharSequence)(prefix + "'")) && StringUtil.endsWith((CharSequence)text, (CharSequence)"'");
    }
}

