/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.psi.PsiFileFactory;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PythonSourceRootConfigurator
implements DirectoryProjectConfigurator {
    @NonNls
    private static final String SETUP_PY = "setup.py";

    @Override
    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/python/PythonSourceRootConfigurator", "configureProject"));
        }
        VirtualFile setupPy = baseDir.findChild(SETUP_PY);
        if (setupPy != null) {
            CharSequence content = LoadTextUtil.loadText(setupPy);
            PyFile setupPyFile = (PyFile)PsiFileFactory.getInstance((Project)project).createFileFromText(SETUP_PY, ((Object)content).toString());
            SetupCallVisitor visitor = new SetupCallVisitor();
            setupPyFile.accept(visitor);
            String dir = visitor.getRootPackageDir();
            if (dir != null) {
                VirtualFile rootPackageVFile = baseDir.findFileByRelativePath(dir);
                PythonSourceRootConfigurator.addSourceRoot(project, baseDir, rootPackageVFile, true);
            }
        }
    }

    private static void addSourceRoot(Project project, final VirtualFile baseDir, final VirtualFile root, final boolean unique) {
        final Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        if (modules.length > 0 && root != null) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ContentEntry[] contentEntries;
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)modules[0]).getModifiableModel();
                    for (ContentEntry contentEntry : contentEntries = model.getContentEntries()) {
                        if (!Comparing.equal((Object)contentEntry.getFile(), (Object)baseDir)) continue;
                        SourceFolder[] sourceFolders = contentEntry.getSourceFolders();
                        if (unique && sourceFolders.length != 0) continue;
                        contentEntry.addSourceFolder(root, false);
                    }
                    model.commit();
                }
            });
        }
    }

    private static class SetupCallVisitor
    extends PyRecursiveElementVisitor {
        private String myRootPackageDir = null;

        private SetupCallVisitor() {
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyArgumentList argList = node.getArgumentList();
            if (node.isCalleeText("setup") && argList != null) {
                PyExpression valueExpression;
                PyKeywordArgument packageDirArg = argList.getKeywordArgument("package_dir");
                if (packageDirArg != null && (valueExpression = packageDirArg.getValueExpression()) instanceof PyDictLiteralExpression) {
                    PyDictLiteralExpression packageDirDict = (PyDictLiteralExpression)valueExpression;
                    for (PyKeyValueExpression keyValue : packageDirDict.getElements()) {
                        PyExpression keyExpr = keyValue.getKey();
                        PyExpression valueExpr = keyValue.getValue();
                        if (!(keyExpr instanceof PyStringLiteralExpression) || !(valueExpr instanceof PyStringLiteralExpression)) continue;
                        String key = ((PyStringLiteralExpression)keyExpr).getStringValue();
                        String value = ((PyStringLiteralExpression)valueExpr).getStringValue();
                        if (key.length() != 0) continue;
                        this.myRootPackageDir = value;
                    }
                }
            } else {
                super.visitPyCallExpression(node);
            }
        }

        public String getRootPackageDir() {
            return this.myRootPackageDir;
        }
    }
}

