/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvSdkFlavor;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PythonSdkConfigurator
implements DirectoryProjectConfigurator {
    @Override
    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        Sdk sdk;
        File virtualEnvRoot;
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/python/PythonSdkConfigurator", "configureProject"));
        }
        PythonSdkType sdkType = PythonSdkType.getInstance();
        ArrayList<String> candidates = new ArrayList<String>();
        if (project == null) {
            return;
        }
        VirtualFile rootDir = project.getBaseDir();
        if (rootDir != null) {
            candidates.addAll(VirtualEnvSdkFlavor.findInDirectory(rootDir));
        }
        if (!candidates.isEmpty()) {
            Sdk virtualEnvSdk;
            String filePath = (String)candidates.get(0);
            if (StringUtil.startsWithChar((CharSequence)filePath, (char)'~')) {
                String home = SystemProperties.getUserHome();
                filePath = home + filePath.substring(1);
            }
            if ((virtualEnvSdk = SdkConfigurationUtil.createAndAddSDK(filePath, sdkType)) != null) {
                SdkConfigurationUtil.setDirectoryProjectSdk(project, virtualEnvSdk);
                SdkAdditionalData additionalData = virtualEnvSdk.getSdkAdditionalData();
                if (additionalData == null) {
                    additionalData = new PythonSdkAdditionalData(PythonSdkFlavor.getFlavor(virtualEnvSdk.getHomePath()));
                    ((ProjectJdkImpl)virtualEnvSdk).setSdkAdditionalData(additionalData);
                }
                ((PythonSdkAdditionalData)additionalData).associateWithProject(project);
                return;
            }
            return;
        }
        Sdk existingSdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (existingSdk != null && existingSdk.getSdkType() == sdkType) {
            return;
        }
        File executableFile = PythonSdkType.findExecutableFile(new File(project.getBasePath(), "bin"), "python");
        if (executableFile != null && (virtualEnvRoot = PythonSdkType.getVirtualEnvRoot(executableFile.getPath())) != null && (sdk = SdkConfigurationUtil.createAndAddSDK(executableFile.getPath(), sdkType)) != null) {
            SdkConfigurationUtil.setDirectoryProjectSdk(project, sdk);
            return;
        }
        SdkConfigurationUtil.configureDirectoryProjectSdk(project, new PreferredSdkComparator(), sdkType);
    }
}

