/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PySdkService;
import com.jetbrains.python.sdk.PythonSdkDetailsStep;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class PythonSdkChooserCombo
extends ComboboxWithBrowseButton {
    private final List<ActionListener> myChangedListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.PythonSdkChooserCombo");

    public PythonSdkChooserCombo(final Project project, List<Sdk> sdks, Condition<Sdk> acceptableSdkCondition) {
        Sdk initialSelection = null;
        for (Sdk sdk : sdks) {
            if (!acceptableSdkCondition.value((Object)sdk)) continue;
            initialSelection = sdk;
            break;
        }
        JComboBox comboBox = this.getComboBox();
        comboBox.setModel(new CollectionComboBoxModel(sdks, initialSelection));
        comboBox.setRenderer(new PySdkListCellRenderer(true));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PythonSdkChooserCombo.this.showOptions(project);
                PythonSdkChooserCombo.this.notifyChanged(e);
            }
        });
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PythonSdkChooserCombo.this.notifyChanged(e);
                PythonSdkChooserCombo.this.updateTooltip();
            }
        });
        this.updateTooltip();
    }

    private void updateTooltip() {
        Object item = this.getComboBox().getSelectedItem();
        this.getComboBox().setToolTipText(item instanceof Sdk ? ((Sdk)item).getHomePath() : null);
    }

    private void showOptions(Project project) {
        final PyConfigurableInterpreterList interpreterList = PyConfigurableInterpreterList.getInstance(project);
        Sdk[] sdks = interpreterList.getModel().getSdks();
        PythonSdkDetailsStep.show(project, sdks, null, (JComponent)((Object)this), this.getButton().getLocationOnScreen(), new NullableConsumer<Sdk>(){

            public void consume(@Nullable Sdk sdk) {
                if (sdk == null) {
                    return;
                }
                PySdkService sdkService = PySdkService.getInstance();
                sdkService.restoreSdk(sdk);
                ProjectSdksModel projectSdksModel = interpreterList.getModel();
                if (projectSdksModel.findSdk(sdk) == null) {
                    projectSdksModel.addSdk(sdk);
                    try {
                        projectSdksModel.apply();
                    }
                    catch (ConfigurationException e) {
                        LOG.error("Error adding new python interpreter " + e.getMessage());
                    }
                }
                PythonSdkChooserCombo.this.getComboBox().setModel(new CollectionComboBoxModel(interpreterList.getAllPythonSdks(), (Object)sdk));
            }
        }, true);
    }

    private void notifyChanged(ActionEvent e) {
        for (ActionListener changedListener : this.myChangedListeners) {
            changedListener.actionPerformed(e);
        }
    }

    public void addChangedListener(ActionListener listener) {
        this.myChangedListeners.add(listener);
    }
}

