/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import org.jetbrains.annotations.NotNull;

public class PythonPsiManager
extends AbstractProjectComponent
implements PsiTreeChangePreprocessor {
    private final PsiManagerImpl myPsiManager;
    private PsiModificationTrackerImpl myModificationTracker;

    public PythonPsiManager(Project project, PsiManagerImpl psiManager) {
        super(project);
        this.myPsiManager = psiManager;
    }

    public void initComponent() {
        this.myModificationTracker = (PsiModificationTrackerImpl)this.myPsiManager.getModificationTracker();
        this.myPsiManager.addTreeChangePreprocessor(this);
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/PythonPsiManager", "treeChanged"));
        }
        if (!(event.getFile() instanceof PyFile)) {
            return;
        }
        boolean changedInsideCodeBlock = false;
        switch (event.getCode()) {
            case BEFORE_CHILDREN_CHANGE: {
                if (event.getParent() instanceof PsiFile) {
                    changedInsideCodeBlock = true;
                    break;
                }
            }
            case CHILDREN_CHANGED: {
                if (event.isGenericChange()) {
                    return;
                }
                changedInsideCodeBlock = PythonPsiManager.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_CHILD_ADDITION: 
            case BEFORE_CHILD_REMOVAL: 
            case CHILD_ADDED: 
            case CHILD_REMOVED: {
                changedInsideCodeBlock = PythonPsiManager.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_PROPERTY_CHANGE: 
            case PROPERTY_CHANGED: {
                changedInsideCodeBlock = false;
                break;
            }
            case BEFORE_CHILD_REPLACEMENT: 
            case CHILD_REPLACED: {
                changedInsideCodeBlock = PythonPsiManager.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_CHILD_MOVEMENT: 
            case CHILD_MOVED: {
                boolean bl = changedInsideCodeBlock = PythonPsiManager.isInsideCodeBlock(event.getOldParent()) && PythonPsiManager.isInsideCodeBlock(event.getNewParent());
            }
        }
        if (!changedInsideCodeBlock) {
            this.myModificationTracker.incOutOfCodeBlockModificationCounter();
        }
    }

    private static boolean isInsideCodeBlock(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return false;
        }
        if (element == null || element.getParent() == null) {
            return true;
        }
        while (!(element instanceof PyFile)) {
            if (element instanceof PsiFile || element instanceof PsiDirectory || element == null) {
                return true;
            }
            PsiElement pparent = element.getParent();
            if (pparent instanceof PyFunction) {
                PyFunction pyFunction = (PyFunction)pparent;
                return element != pyFunction.getParameterList() && element != pyFunction.getNameIdentifier();
            }
            element = pparent;
        }
        return false;
    }
}

