/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonIndentingLexer;
import com.jetbrains.python.parsing.PyParser;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyFileElementType;
import com.jetbrains.python.psi.PyStubElementType;
import com.jetbrains.python.psi.impl.PyFileImpl;
import org.jetbrains.annotations.NotNull;

public class PythonParserDefinition
implements ParserDefinition {
    private final TokenSet myWhitespaceTokens = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LINE_BREAK, PyTokenTypes.SPACE, PyTokenTypes.TAB, PyTokenTypes.FORMFEED});
    private final TokenSet myCommentTokens = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.END_OF_LINE_COMMENT});
    private final TokenSet myStringLiteralTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{PyTokenTypes.STRING_NODES, TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.STRING_LITERAL_EXPRESSION})});

    @NotNull
    public Lexer createLexer(Project project) {
        PythonIndentingLexer pythonIndentingLexer = new PythonIndentingLexer();
        if (pythonIndentingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonParserDefinition", "createLexer"));
        }
        return pythonIndentingLexer;
    }

    public IFileElementType getFileNodeType() {
        return PyFileElementType.INSTANCE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = this.myWhitespaceTokens;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = this.myCommentTokens;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = this.myStringLiteralTokens;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiParser createParser(Project project) {
        PyParser pyParser = new PyParser();
        if (pyParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonParserDefinition", "createParser"));
        }
        return pyParser;
    }

    @NotNull
    public PsiElement createElement(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/PythonParserDefinition", "createElement"));
        }
        IElementType type = node.getElementType();
        if (type instanceof PyElementType) {
            PyElementType pyElType = (PyElementType)type;
            PsiElement psiElement = pyElType.createElement(node);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonParserDefinition", "createElement"));
            }
            return psiElement;
        }
        if (type instanceof PyStubElementType) {
            PsiElement psiElement = ((PyStubElementType)type).createElement(node);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonParserDefinition", "createElement"));
            }
            return psiElement;
        }
        ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
        if (aSTWrapperPsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonParserDefinition", "createElement"));
        }
        return aSTWrapperPsiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new PyFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

