/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.facet.FacetType;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import icons.PythonIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PythonModuleTypeBase<T extends ModuleBuilder>
extends ModuleType<T> {
    @NonNls
    public static final String PYTHON_MODULE = "PYTHON_MODULE";

    public static ModuleType getInstance() {
        return ModuleTypeManager.getInstance().findByID(PYTHON_MODULE);
    }

    protected PythonModuleTypeBase() {
        super(PYTHON_MODULE);
    }

    @NotNull
    public String getName() {
        if ("Python Module" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonModuleTypeBase", "getName"));
        }
        return "Python Module";
    }

    @NotNull
    public String getDescription() {
        FacetType[] facetTypes;
        String basicDescription = "Python modules are used for developing <b>Python</b> applications.";
        for (FacetType type : facetTypes = (FacetType[])Extensions.getExtensions((ExtensionPointName)FacetType.EP_NAME)) {
            if (!type.getId().toString().equalsIgnoreCase("django")) continue;
            String string = basicDescription + " Supported technologies include <b>Django, Google App Engine, Mako, Jinja2</b> and others.";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonModuleTypeBase", "getDescription"));
            }
            return string;
        }
        String string = basicDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonModuleTypeBase", "getDescription"));
        }
        return string;
    }

    public Icon getBigIcon() {
        return PythonIcons.Python.Python_24;
    }

    public Icon getNodeIcon(boolean isOpened) {
        return PythonIcons.Python.PythonClosed;
    }
}

