/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import java.io.File;

public class PythonHelpersLocator {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.PythonHelpersLocator");
    private static final String COMMUNITY_SUFFIX = "-community";

    private PythonHelpersLocator() {
    }

    public static File getHelpersRoot() {
        String jarPath = PathUtil.getJarPathForClass(PythonHelpersLocator.class);
        if (jarPath.endsWith(".jar")) {
            File jarFile = new File(jarPath);
            LOG.assertTrue(jarFile.exists(), (Object)"jar file cannot be null");
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, "helpers");
        }
        if (jarPath.endsWith(COMMUNITY_SUFFIX)) {
            jarPath = jarPath.substring(0, jarPath.length() - COMMUNITY_SUFFIX.length());
        }
        return new File(jarPath + "-helpers");
    }

    public static String getHelperPath(String resourceName) {
        return PythonHelpersLocator.getHelperFile(resourceName).getAbsolutePath();
    }

    public static File getHelperFile(String resourceName) {
        return new File(PythonHelpersLocator.getHelpersRoot(), resourceName);
    }

    public static String getPythonCommunityPath() {
        File pathFromUltimate = new File(PathManager.getHomePath(), "community/python");
        if (pathFromUltimate.exists()) {
            return pathFromUltimate.getPath();
        }
        return new File(PathManager.getHomePath(), "python").getPath();
    }
}

