/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFileElementType;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyFileImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/jetbrains/python/PythonFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/jetbrains/python/PythonFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/python/PythonFoldingBuilder", "buildLanguageFoldRegions"));
        }
        PythonFoldingBuilder.appendDescriptors(root.getNode(), descriptors);
    }

    private static void appendDescriptors(ASTNode node, List<FoldingDescriptor> descriptors) {
        if (node.getElementType() instanceof PyFileElementType) {
            List<PyImportStatementBase> imports = ((PyFile)node.getPsi()).getImportBlock();
            if (imports.size() > 1) {
                PyImportStatementBase firstImport = imports.get(0);
                PyImportStatementBase lastImport = imports.get(imports.size() - 1);
                descriptors.add(new FoldingDescriptor((PsiElement)firstImport, new TextRange(firstImport.getTextRange().getStartOffset(), lastImport.getTextRange().getEndOffset())));
            }
        } else if (node.getElementType() == PyElementTypes.STATEMENT_LIST) {
            PythonFoldingBuilder.foldStatementList(node, descriptors);
        } else if (node.getElementType() == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            PythonFoldingBuilder.foldDocString(node, descriptors);
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PythonFoldingBuilder.appendDescriptors(child, descriptors);
        }
    }

    private static void foldStatementList(ASTNode node, List<FoldingDescriptor> descriptors) {
        IElementType elType = node.getTreeParent().getElementType();
        if (elType == PyElementTypes.FUNCTION_DECLARATION || elType == PyElementTypes.CLASS_DECLARATION) {
            ASTNode colon = node.getTreeParent().findChildByType((IElementType)PyTokenTypes.COLON);
            if (colon != null && colon.getStartOffset() + 1 < node.getTextRange().getEndOffset() - 1) {
                int endOffset;
                CharSequence chars = node.getChars();
                int nodeStart = node.getTextRange().getStartOffset();
                for (endOffset = node.getTextRange().getEndOffset(); endOffset > colon.getStartOffset() + 2 && endOffset > nodeStart && Character.isWhitespace(chars.charAt(endOffset - nodeStart - 1)); --endOffset) {
                }
                descriptors.add(new FoldingDescriptor(node, new TextRange(colon.getStartOffset() + 1, endOffset)));
            } else {
                TextRange range = node.getTextRange();
                if (range.getStartOffset() < range.getEndOffset() - 1) {
                    descriptors.add(new FoldingDescriptor(node, range));
                }
            }
        }
    }

    private static void foldDocString(ASTNode node, List<FoldingDescriptor> descriptors) {
        if (PythonFoldingBuilder.getDocStringOwnerType(node) != null && StringUtil.countChars((CharSequence)node.getText(), (char)'\n') > 1) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
    }

    @Nullable
    private static IElementType getDocStringOwnerType(ASTNode node) {
        ASTNode treeParent = node.getTreeParent();
        IElementType parentType = treeParent.getElementType();
        if (parentType == PyElementTypes.EXPRESSION_STATEMENT && treeParent.getTreeParent() != null) {
            ASTNode parent2 = treeParent.getTreeParent();
            if (parent2.getElementType() == PyElementTypes.STATEMENT_LIST && parent2.getTreeParent() != null && treeParent == parent2.getFirstChildNode()) {
                ASTNode parent3 = parent2.getTreeParent();
                if (parent3.getElementType() == PyElementTypes.FUNCTION_DECLARATION || parent3.getElementType() == PyElementTypes.CLASS_DECLARATION) {
                    return parent3.getElementType();
                }
            } else if (parent2.getElementType() instanceof PyFileElementType) {
                return parent2.getElementType();
            }
        }
        return null;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/PythonFoldingBuilder", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/jetbrains/python/PythonFoldingBuilder", "getLanguagePlaceholderText"));
        }
        if (PyFileImpl.isImport(node, false)) {
            return "import ...";
        }
        if (node.getElementType() == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            String stringValue = ((PyStringLiteralExpression)node.getPsi()).getStringValue().trim();
            String[] lines = LineTokenizer.tokenize((CharSequence)stringValue, (boolean)true);
            if (lines.length > 2 && lines[1].trim().length() == 0) {
                return "\"\"\"" + lines[0].trim() + "...\"\"\"";
            }
            return "\"\"\"...\"\"\"";
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/PythonFoldingBuilder", "isRegionCollapsedByDefault"));
        }
        if (PyFileImpl.isImport(node, false)) {
            return CodeFoldingSettings.getInstance().COLLAPSE_IMPORTS;
        }
        if (node.getElementType() == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            if (PythonFoldingBuilder.getDocStringOwnerType(node) == PyElementTypes.FUNCTION_DECLARATION && CodeFoldingSettings.getInstance().COLLAPSE_METHODS) {
                return false;
            }
            return CodeFoldingSettings.getInstance().COLLAPSE_DOC_COMMENTS;
        }
        if (node.getElementType() == PyElementTypes.STATEMENT_LIST && node.getTreeParent().getElementType() == PyElementTypes.FUNCTION_DECLARATION) {
            return CodeFoldingSettings.getInstance().COLLAPSE_METHODS;
        }
        return false;
    }

    protected boolean isCustomFoldingCandidate(ASTNode node) {
        return node.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(ASTNode node) {
        return node.getPsi() instanceof PyFile || node.getElementType() == PyElementTypes.STATEMENT_LIST;
    }
}

