/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PythonLanguage;
import icons.PythonPsiApiIcons;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonFileType
extends LanguageFileType {
    private static final Pattern ENCODING_PATTERN = Pattern.compile("coding[:=]\\s*([-\\w.]+)");
    public static final int MAX_CHARSET_ENCODING_LINE = 2;
    public static PythonFileType INSTANCE = new PythonFileType();

    public PythonFileType() {
        this(new PythonLanguage());
    }

    public PythonFileType(Language language) {
        super(language);
    }

    @NotNull
    public String getName() {
        if ("Python" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonFileType", "getName"));
        }
        return "Python";
    }

    @NotNull
    public String getDescription() {
        if ("Python files" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonFileType", "getDescription"));
        }
        return "Python files";
    }

    @NotNull
    public String getDefaultExtension() {
        if ("py" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonFileType", "getDefaultExtension"));
        }
        return "py";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = PythonPsiApiIcons.PythonFile;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PythonFileType", "getIcon"));
        }
        return icon;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/PythonFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/python/PythonFileType", "getCharset"));
        }
        if (CharsetToolkit.hasUTF8Bom((byte[])content)) {
            return "UTF-8";
        }
        ByteBuffer bytes = ByteBuffer.wrap(content, 0, Math.min(256, content.length));
        String decoded = CharsetToolkit.UTF8_CHARSET.decode(bytes).toString();
        return PythonFileType.getCharsetFromEncodingDeclaration(StringUtil.convertLineSeparators((String)decoded));
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/python/PythonFileType", "extractCharsetFromFileContent"));
        }
        String charsetName = PythonFileType.getCharsetFromEncodingDeclaration(content);
        if (charsetName == null) {
            return null;
        }
        try {
            return Charset.forName(charsetName);
        }
        catch (IllegalCharsetNameException e) {
            return null;
        }
        catch (UnsupportedCharsetException e) {
            return null;
        }
    }

    @Nullable
    public static String getCharsetFromEncodingDeclaration(@NotNull PsiFile file) {
        String content;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/PythonFileType", "getCharsetFromEncodingDeclaration"));
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document != null && document.getLineCount() > 2) {
            int offset = document.getLineEndOffset(2);
            content = document.getText(TextRange.create((int)0, (int)offset));
        } else {
            content = file.getText();
        }
        return PythonFileType.getCharsetFromEncodingDeclaration(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String getCharsetFromEncodingDeclaration(@Nullable String content) {
        if (content == null) return null;
        if (content.isEmpty()) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(content));
            try {
                int i = 0;
                while (i < 2) {
                    String line = reader.readLine();
                    if (line == null) {
                        String string = null;
                        return string;
                    }
                    Matcher matcher = ENCODING_PATTERN.matcher(line);
                    if (matcher.find()) {
                        String charset = matcher.group(1);
                        String string = PythonFileType.normalizeCharset(charset);
                        return string;
                    }
                    ++i;
                }
                return null;
            }
            finally {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String normalizeCharset(String charset) {
        if (charset == null) {
            return null;
        }
        if ("latin-1".equals(charset = charset.toLowerCase())) {
            return "iso-8859-1";
        }
        return charset;
    }
}

