/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyParameterInfoHandler
implements ParameterInfoHandler<PyArgumentList, CallArgumentsMapping> {
    private static final String NO_PARAMS_MSG = CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);

    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public Object[] getParametersForDocumentation(CallArgumentsMapping p, ParameterInfoContext context) {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public PyArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/PyParameterInfoHandler", "findElementForParameterInfo"));
        }
        PyArgumentList arglist = PyParameterInfoHandler.findArgumentList((ParameterInfoContext)context);
        if (arglist != null) {
            TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(arglist.getProject(), arglist.getContainingFile());
            PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(typeEvalContext);
            CallArgumentsMapping result = arglist.analyzeCall(resolveContext);
            if (result.getMarkedCallee() != null) {
                context.setItemsToShow(new Object[]{result});
                return arglist;
            }
        }
        return null;
    }

    private static PyArgumentList findArgumentList(ParameterInfoContext context) {
        return (PyArgumentList)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), PyArgumentList.class);
    }

    public void showParameterInfo(@NotNull PyArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/PyParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/PyParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    public PyArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/PyParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return PyParameterInfoHandler.findArgumentList((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull PyArgumentList arglist, @NotNull UpdateParameterInfoContext context) {
        if (arglist == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arglist", "com/jetbrains/python/PyParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/PyParameterInfoHandler", "updateParameterInfo"));
        }
        if (context.getParameterOwner() != arglist) {
            context.removeHint();
            return;
        }
        List<PyExpression> flat_args = PyUtil.flattenedParensAndLists(arglist.getArguments());
        int alleged_cursor_offset = context.getOffset();
        TextRange argListTextRange = arglist.getTextRange();
        if (!argListTextRange.contains(alleged_cursor_offset) && arglist.getText().endsWith(")")) {
            context.removeHint();
            return;
        }
        PsiFile file = context.getFile();
        CharSequence chars = file.getViewProvider().getContents();
        int offset = -1;
        for (PyExpression arg : flat_args) {
            TextRange range = arg.getTextRange();
            int left = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(range.getStartOffset() - 1), (String)" \t\r\n");
            int right = CharArrayUtil.shiftForwardCarefully((CharSequence)chars, (int)range.getEndOffset(), (String)" \t\r\n");
            if (arg.getParent() instanceof PyListLiteralExpression || arg.getParent() instanceof PyTupleExpression) {
                right = CharArrayUtil.shiftForward((CharSequence)chars, (int)range.getEndOffset(), (String)" \t\r\n])");
            }
            if (left > alleged_cursor_offset || right < alleged_cursor_offset) continue;
            offset = range.getStartOffset();
            break;
        }
        context.setCurrentParameter(offset);
    }

    public String getParameterCloseChars() {
        return ",()";
    }

    public boolean tracksParameterIndex() {
        return false;
    }

    public void updateUI(CallArgumentsMapping prevResult, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/PyParameterInfoHandler", "updateUI"));
        }
        if (prevResult == null) {
            return;
        }
        PyArgumentList argList = prevResult.getArgumentList();
        if (!argList.isValid()) {
            return;
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(argList.getProject(), argList.getContainingFile());
        PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(typeEvalContext);
        CallArgumentsMapping argumentsMapping = argList.analyzeCall(resolveContext);
        PyCallExpression.PyMarkedCallee marked = argumentsMapping.getMarkedCallee();
        if (marked == null) {
            return;
        }
        Callable callable = marked.getCallable();
        List<PyParameter> parameterList = PyUtil.getParameters(callable, typeEvalContext);
        ArrayList<PyNamedParameter> namedParameters = new ArrayList<PyNamedParameter>(parameterList.size());
        HashMap<PyNamedParameter, Integer> parameterToIndex = new HashMap<PyNamedParameter, Integer>();
        HashMap<Integer, EnumSet<ParameterInfoUIContextEx.Flag>> hintFlags = new HashMap<Integer, EnumSet<ParameterInfoUIContextEx.Flag>>();
        List<String> hintsList = PyParameterInfoHandler.buildParameterListHint(parameterList, namedParameters, parameterToIndex, hintFlags);
        int currentParamOffset = context.getCurrentParameterIndex();
        for (int i = 0; i < marked.getImplicitOffset(); ++i) {
            ((EnumSet)hintFlags.get(parameterToIndex.get(namedParameters.get(i)))).add(ParameterInfoUIContextEx.Flag.DISABLE);
        }
        List<PyExpression> flattenedArgs = PyUtil.flattenedParensAndLists(argList.getArguments());
        int lastParamIndex = PyParameterInfoHandler.collectHighlights(argumentsMapping, parameterList, parameterToIndex, hintFlags, flattenedArgs, currentParamOffset);
        PyParameterInfoHandler.highlightNext(marked, parameterList, namedParameters, parameterToIndex, hintFlags, flattenedArgs.isEmpty(), lastParamIndex);
        String[] hints = ArrayUtil.toStringArray(hintsList);
        if (context instanceof ParameterInfoUIContextEx) {
            ParameterInfoUIContextEx pic = (ParameterInfoUIContextEx)context;
            EnumSet[] flags = new EnumSet[hintFlags.size()];
            for (int i = 0; i < flags.length; ++i) {
                flags[i] = (EnumSet)hintFlags.get(i);
            }
            if (hints.length < 1) {
                hints = new String[]{NO_PARAMS_MSG};
                flags = new EnumSet[]{EnumSet.of(ParameterInfoUIContextEx.Flag.DISABLE)};
            }
            pic.setupUIComponentPresentation(hints, flags, context.getDefaultParameterColor());
        } else {
            StringBuilder signatureBuilder = new StringBuilder();
            if (hints.length > 1) {
                for (String s : hints) {
                    signatureBuilder.append(s);
                }
            } else {
                signatureBuilder.append(XmlStringUtil.escapeString((String)NO_PARAMS_MSG));
            }
            context.setupUIComponentPresentation(signatureBuilder.toString(), -1, 0, false, false, false, context.getDefaultParameterColor());
        }
    }

    private static void highlightNext(@NotNull PyCallExpression.PyMarkedCallee marked, @NotNull List<PyParameter> parameterList, @NotNull List<PyNamedParameter> namedParameters, @NotNull Map<PyNamedParameter, Integer> parameterToIndex, @NotNull Map<Integer, EnumSet<ParameterInfoUIContextEx.Flag>> hintFlags, boolean isArgsEmpty, int lastParamIndex) {
        if (marked == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marked", "com/jetbrains/python/PyParameterInfoHandler", "highlightNext"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/jetbrains/python/PyParameterInfoHandler", "highlightNext"));
        }
        if (namedParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedParameters", "com/jetbrains/python/PyParameterInfoHandler", "highlightNext"));
        }
        if (parameterToIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterToIndex", "com/jetbrains/python/PyParameterInfoHandler", "highlightNext"));
        }
        if (hintFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintFlags", "com/jetbrains/python/PyParameterInfoHandler", "highlightNext"));
        }
        boolean canOfferNext = true;
        for (EnumSet<ParameterInfoUIContextEx.Flag> set : hintFlags.values()) {
            if (!set.contains(ParameterInfoUIContextEx.Flag.HIGHLIGHT)) continue;
            canOfferNext = false;
        }
        if (canOfferNext) {
            int highlightIndex = Integer.MAX_VALUE;
            if (isArgsEmpty) {
                highlightIndex = marked.getImplicitOffset();
            } else if (lastParamIndex < parameterList.size() - 1) {
                highlightIndex = namedParameters.get(lastParamIndex).isPositionalContainer() ? lastParamIndex : lastParamIndex + 1;
            } else if (lastParamIndex == parameterList.size() - 1 && (namedParameters.get(lastParamIndex).isPositionalContainer() || namedParameters.get(lastParamIndex).isKeywordContainer())) {
                highlightIndex = lastParamIndex;
            }
            if (highlightIndex < namedParameters.size()) {
                hintFlags.get(parameterToIndex.get(namedParameters.get(highlightIndex))).add(ParameterInfoUIContextEx.Flag.HIGHLIGHT);
            }
        }
    }

    private static int collectHighlights(@NotNull CallArgumentsMapping argumentsMapping, @NotNull List<PyParameter> parameterList, @NotNull Map<PyNamedParameter, Integer> parameterToIndex, @NotNull Map<Integer, EnumSet<ParameterInfoUIContextEx.Flag>> hintFlags, @NotNull List<PyExpression> flatArgs, int currentParamOffset) {
        if (argumentsMapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentsMapping", "com/jetbrains/python/PyParameterInfoHandler", "collectHighlights"));
        }
        if (parameterList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterList", "com/jetbrains/python/PyParameterInfoHandler", "collectHighlights"));
        }
        if (parameterToIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterToIndex", "com/jetbrains/python/PyParameterInfoHandler", "collectHighlights"));
        }
        if (hintFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintFlags", "com/jetbrains/python/PyParameterInfoHandler", "collectHighlights"));
        }
        if (flatArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flatArgs", "com/jetbrains/python/PyParameterInfoHandler", "collectHighlights"));
        }
        PyCallExpression.PyMarkedCallee callee = argumentsMapping.getMarkedCallee();
        assert (callee != null);
        int lastParamIndex = callee.getImplicitOffset();
        for (PyExpression arg : flatArgs) {
            boolean mustHighlight = arg.getTextRange().contains(currentParamOffset);
            PyExpression seeker = arg;
            while (!(seeker instanceof PyArgumentList) && seeker instanceof PyExpression && !argumentsMapping.getPlainMappedParams().containsKey(seeker)) {
                seeker = seeker.getParent();
            }
            if (seeker instanceof PyExpression) {
                PyNamedParameter parameter = argumentsMapping.getPlainMappedParams().get(seeker);
                lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                if (parameter == null) continue;
                PyParameterInfoHandler.highlightParameter(parameter, parameterToIndex, hintFlags, mustHighlight);
                continue;
            }
            if (arg == argumentsMapping.getTupleArg()) {
                for (PyNamedParameter parameter : argumentsMapping.getTupleMappedParams()) {
                    lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                    PyParameterInfoHandler.highlightParameter(parameter, parameterToIndex, hintFlags, mustHighlight);
                }
                continue;
            }
            if (arg == argumentsMapping.getKwdArg()) {
                for (PyNamedParameter parameter : argumentsMapping.getKwdMappedParams()) {
                    lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                    PyParameterInfoHandler.highlightParameter(parameter, parameterToIndex, hintFlags, mustHighlight);
                }
                continue;
            }
            List<PyNamedParameter> namedParameters = argumentsMapping.getNestedMappedParams().get(arg);
            if (namedParameters == null) continue;
            for (PyNamedParameter parameter : namedParameters) {
                lastParamIndex = Math.max(lastParamIndex, parameterList.indexOf(parameter));
                PyParameterInfoHandler.highlightParameter(parameter, parameterToIndex, hintFlags, mustHighlight);
            }
        }
        return lastParamIndex;
    }

    private static void highlightParameter(@NotNull PyNamedParameter parameter, @NotNull Map<PyNamedParameter, Integer> parameterToIndex, @NotNull Map<Integer, EnumSet<ParameterInfoUIContextEx.Flag>> hintFlags, boolean mustHighlight) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/python/PyParameterInfoHandler", "highlightParameter"));
        }
        if (parameterToIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterToIndex", "com/jetbrains/python/PyParameterInfoHandler", "highlightParameter"));
        }
        if (hintFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintFlags", "com/jetbrains/python/PyParameterInfoHandler", "highlightParameter"));
        }
        Integer parameterIndex = parameterToIndex.get(parameter);
        if (mustHighlight && parameterIndex != null && parameterIndex < hintFlags.size()) {
            hintFlags.get(parameterIndex).add(ParameterInfoUIContextEx.Flag.HIGHLIGHT);
        }
    }

    private static List<String> buildParameterListHint(@NotNull List<PyParameter> parameters, final @NotNull List<PyNamedParameter> namedParameters, final @NotNull Map<PyNamedParameter, Integer> parameterToIndex, final @NotNull Map<Integer, EnumSet<ParameterInfoUIContextEx.Flag>> hintFlags) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/python/PyParameterInfoHandler", "buildParameterListHint"));
        }
        if (namedParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedParameters", "com/jetbrains/python/PyParameterInfoHandler", "buildParameterListHint"));
        }
        if (parameterToIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterToIndex", "com/jetbrains/python/PyParameterInfoHandler", "buildParameterListHint"));
        }
        if (hintFlags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintFlags", "com/jetbrains/python/PyParameterInfoHandler", "buildParameterListHint"));
        }
        final ArrayList<String> hintsList = new ArrayList<String>();
        ParamHelper.walkDownParamArray(parameters.toArray(new PyParameter[parameters.size()]), new ParamHelper.ParamWalker(){

            @Override
            public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                hintFlags.put(hintsList.size(), EnumSet.noneOf(ParameterInfoUIContextEx.Flag.class));
                hintsList.add("(");
            }

            @Override
            public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                hintFlags.put(hintsList.size(), EnumSet.noneOf(ParameterInfoUIContextEx.Flag.class));
                hintsList.add(last ? ")" : "), ");
            }

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                namedParameters.add(param);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(param.getRepr(true));
                if (!last) {
                    stringBuilder.append(", ");
                }
                int hintIndex = hintsList.size();
                parameterToIndex.put(param, hintIndex);
                hintFlags.put(hintIndex, EnumSet.noneOf(ParameterInfoUIContextEx.Flag.class));
                hintsList.add(stringBuilder.toString());
            }

            @Override
            public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
                hintFlags.put(hintsList.size(), EnumSet.noneOf(ParameterInfoUIContextEx.Flag.class));
                hintsList.add(last ? "*" : "*, ");
            }
        });
        return hintsList;
    }
}

