/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.util.PathMappingsComponent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.impl.SdkListCellRenderer;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PyConfigureInterpretersLinkPanel;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class PyIdeCommonOptionsForm
implements AbstractPyCommonOptionsForm {
    private JPanel myMainPanel;
    private EnvironmentVariablesComponent myEnvsComponent;
    private RawCommandLineEditor myInterpreterOptionsTextField;
    private TextFieldWithBrowseButton myWorkingDirectoryTextField;
    private JComboBox myInterpreterComboBox;
    private JBLabel myPythonInterpreterJBLabel;
    private JLabel myProjectLabel;
    private ModulesComboBox myModuleCombo;
    private JPanel myConfigureInterpretersPanel;
    private String mySelectedSdkHome = null;
    private PathMappingsComponent myPathMappingsComponent;
    private JPanel myHideablePanel;
    private JBCheckBox myAddContentRootsCheckbox;
    private JBCheckBox myAddSourceRootsCheckbox;
    private JComponent labelAnchor;
    private final Project myProject;
    private List<Sdk> myPythonSdks;
    private boolean myInterpreterRemote;
    private final HideableDecorator myDecorator;

    public PyIdeCommonOptionsForm(PyCommonOptionsFormData data) {
        this.$$$setupUI$$$();
        this.myProject = data.getProject();
        this.myWorkingDirectoryTextField.addBrowseFolderListener("Select Working Directory", "", data.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myPythonSdks = new ArrayList<Sdk>(PythonSdkType.getAllSdks());
        this.myPythonSdks.add(0, null);
        this.myInterpreterComboBox.setModel(new CollectionComboBoxModel(this.myPythonSdks, null));
        Module[] modules = ModuleManager.getInstance((Project)data.getProject()).getModules();
        if (modules.length == 1) {
            this.setModule(modules[0]);
            this.myProjectLabel.setVisible(false);
            this.myModuleCombo.setVisible(false);
        } else {
            List<Module> validModules = data.getValidModules();
            Module selection = validModules.size() > 0 ? validModules.get(0) : null;
            this.myModuleCombo.setModules(validModules);
            this.myModuleCombo.setSelectedModule(selection);
            this.myModuleCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PyIdeCommonOptionsForm.this.updateDefaultInterpreter(PyIdeCommonOptionsForm.this.myModuleCombo.getSelectedModule());
                }
            });
            this.updateDefaultInterpreter(this.myModuleCombo.getSelectedModule());
        }
        this.setAnchor((JComponent)this.myEnvsComponent.getLabel());
        this.myPathMappingsComponent.setAnchor((JComponent)this.myEnvsComponent.getLabel());
        if (data.showConfigureInterpretersLink()) {
            this.myConfigureInterpretersPanel.add(new PyConfigureInterpretersLinkPanel(this.myMainPanel));
        }
        this.addInterpreterComboBoxActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PyIdeCommonOptionsForm.this.updateRemoteInterpreterMode();
            }
        });
        this.updateRemoteInterpreterMode();
        this.myDecorator = new HideableDecorator(this.myHideablePanel, "Environment", false){

            @Override
            protected void on() {
                super.on();
                this.storeState();
            }

            @Override
            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance().setValue("ExpandEnvironmentPanel", String.valueOf(this.isExpanded()));
            }
        };
        this.myDecorator.setOn(PropertiesComponent.getInstance().getBoolean("ExpandEnvironmentPanel", true));
        this.myDecorator.setContentComponent(this.myMainPanel);
    }

    @Override
    public JComponent getMainPanel() {
        return this.myHideablePanel;
    }

    @Override
    public void subscribe() {
        PyConfigurableInterpreterList myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        ProjectSdksModel myProjectSdksModel = myInterpreterList.getModel();
        myProjectSdksModel.addListener(new MyListener(this, myInterpreterList));
        this.updateSdkList(true, myInterpreterList);
    }

    public JComponent getAnchor() {
        return this.labelAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.labelAnchor = anchor;
        this.myEnvsComponent.setAnchor(anchor);
        this.myPythonInterpreterJBLabel.setAnchor(anchor);
    }

    @Override
    public String getInterpreterOptions() {
        return this.myInterpreterOptionsTextField.getText().trim();
    }

    @Override
    public void setInterpreterOptions(String interpreterOptions) {
        this.myInterpreterOptionsTextField.setText(interpreterOptions);
    }

    @Override
    public String getWorkingDirectory() {
        return FileUtil.toSystemIndependentName((String)this.myWorkingDirectoryTextField.getText().trim());
    }

    @Override
    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectoryTextField.setText(workingDirectory == null ? "" : FileUtil.toSystemDependentName((String)workingDirectory));
    }

    @Override
    public String getSdkHome() {
        Sdk selectedSdk = (Sdk)this.myInterpreterComboBox.getSelectedItem();
        return selectedSdk == null ? null : selectedSdk.getHomePath();
    }

    @Override
    public void setSdkHome(String sdkHome) {
        this.mySelectedSdkHome = sdkHome;
    }

    @Override
    @Nullable
    public Module getModule() {
        Module selectedItem = this.myModuleCombo.getSelectedModule();
        if (selectedItem != null) {
            return selectedItem;
        }
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules.length == 1) {
            return modules[0];
        }
        return null;
    }

    @Override
    public void setModule(Module module) {
        this.myModuleCombo.setSelectedModule(module);
        this.updateDefaultInterpreter(module);
    }

    private void updateDefaultInterpreter(Module module) {
        Sdk sdk = module == null ? null : ModuleRootManager.getInstance((Module)module).getSdk();
        String projectSdkName = sdk == null ? "none" : sdk.getName();
        this.myInterpreterComboBox.setRenderer(new SdkListCellRenderer("Project Default (" + projectSdkName + ")"));
    }

    public void updateSdkList(boolean preserveSelection, PyConfigurableInterpreterList myInterpreterList) {
        Sdk selection;
        this.myPythonSdks = myInterpreterList.getAllPythonSdks(this.myProject);
        Sdk sdk = selection = preserveSelection ? (Sdk)this.myInterpreterComboBox.getSelectedItem() : null;
        if (!this.myPythonSdks.contains(selection)) {
            selection = null;
        }
        this.myPythonSdks.add(0, null);
        this.myInterpreterComboBox.setModel(new CollectionComboBoxModel(this.myPythonSdks, (Object)selection));
    }

    @Override
    public boolean isUseModuleSdk() {
        return this.myInterpreterComboBox.getSelectedItem() == null;
    }

    @Override
    public void setUseModuleSdk(boolean useModuleSdk) {
        this.myInterpreterComboBox.setSelectedItem(useModuleSdk ? null : PythonSdkType.findSdkByPath(this.myPythonSdks, this.mySelectedSdkHome));
    }

    @Override
    public boolean isPassParentEnvs() {
        return this.myEnvsComponent.isPassParentEnvs();
    }

    @Override
    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myEnvsComponent.setPassParentEnvs(passParentEnvs);
    }

    @Override
    public Map<String, String> getEnvs() {
        return this.myEnvsComponent.getEnvs();
    }

    @Override
    public void setEnvs(Map<String, String> envs) {
        this.myEnvsComponent.setEnvs(envs);
    }

    @Override
    @Nullable
    public PathMappingSettings getMappingSettings() {
        if (this.myInterpreterRemote) {
            return this.myPathMappingsComponent.getMappingSettings();
        }
        return new PathMappingSettings();
    }

    @Override
    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myPathMappingsComponent.setMappingSettings(mappingSettings);
    }

    @Override
    public boolean shouldAddContentRoots() {
        return this.myAddContentRootsCheckbox.isSelected();
    }

    @Override
    public boolean shouldAddSourceRoots() {
        return this.myAddSourceRootsCheckbox.isSelected();
    }

    @Override
    public void setAddContentRoots(boolean flag) {
        this.myAddContentRootsCheckbox.setSelected(flag);
    }

    @Override
    public void setAddSourceRoots(boolean flag) {
        this.myAddSourceRootsCheckbox.setSelected(flag);
    }

    private void createUIComponents() {
        this.myInterpreterComboBox = new ComboBox(100);
    }

    private void setRemoteInterpreterMode(boolean isInterpreterRemote) {
        this.myInterpreterRemote = isInterpreterRemote;
        this.myPathMappingsComponent.setVisible(isInterpreterRemote);
    }

    private void updateRemoteInterpreterMode() {
        this.setRemoteInterpreterMode(PySdkUtil.isRemote(this.getSdkSelected()));
    }

    @Nullable
    private Sdk getSdkSelected() {
        Sdk projectJdk;
        String sdkHome = this.getSdkHome();
        if (StringUtil.isEmptyOrSpaces((String)sdkHome) && (projectJdk = PythonSdkType.findPythonSdk(this.getModule())) != null) {
            sdkHome = projectJdk.getHomePath();
        }
        return PythonSdkType.findSdkByPath(sdkHome);
    }

    @Override
    public void addInterpreterComboBoxActionListener(ActionListener listener) {
        this.myInterpreterComboBox.addActionListener(listener);
    }

    @Override
    public void removeInterpreterComboBoxActionListener(ActionListener listener) {
        this.myInterpreterComboBox.removeActionListener(listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        PathMappingsComponent pathMappingsComponent;
        JPanel jPanel;
        ModulesComboBox modulesComboBox;
        JLabel jLabel;
        EnvironmentVariablesComponent environmentVariablesComponent;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myHideablePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, "Center");
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Interpreter options:");
        jLabel2.setDisplayedMnemonic('I');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterOptionsTextField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("Enter interpreter options");
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Working directory:");
        jLabel3.setDisplayedMnemonic('W');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkingDirectoryTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myPythonInterpreterJBLabel = jBLabel = new JBLabel();
        jBLabel.setText("Python interpreter:");
        jBLabel.setDisplayedMnemonic('P');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.myInterpreterComboBox;
        jPanel2.add((Component)jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myEnvsComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        environmentVariablesComponent.setText("&Environment variables");
        jPanel2.add((Component)((Object)environmentVariablesComponent), new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myProjectLabel = jLabel = new JLabel();
        jLabel.setText("Project:");
        jLabel.setDisplayedMnemonic('J');
        jLabel.setDisplayedMnemonicIndex(3);
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleCombo = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)((Object)modulesComboBox), new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigureInterpretersPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPathMappingsComponent = pathMappingsComponent = new PathMappingsComponent();
        pathMappingsComponent.setText("Path mappings");
        pathMappingsComponent.setLabelLocation("West");
        jPanel2.add((Component)pathMappingsComponent, new GridConstraints(5, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myAddContentRootsCheckbox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setSelected(true);
        jBCheckBox2.setText("Add content roots to PYTHONPATH");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myAddSourceRootsCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        jBCheckBox.setText("Add source roots to PYTHONPATH");
        jPanel2.add((Component)jBCheckBox, new GridConstraints(8, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myHideablePanel;
    }

    private static class MyListener
    implements SdkModel.Listener {
        private final PyIdeCommonOptionsForm myForm;
        private PyConfigurableInterpreterList myInterpreterList;

        public MyListener(PyIdeCommonOptionsForm form, PyConfigurableInterpreterList interpreterList) {
            this.myForm = form;
            this.myInterpreterList = interpreterList;
        }

        private void update() {
            this.myForm.updateSdkList(true, this.myInterpreterList);
        }

        public void sdkAdded(Sdk sdk) {
            this.update();
        }

        public void beforeSdkRemove(Sdk sdk) {
            this.update();
        }

        public void sdkChanged(Sdk sdk, String previousName) {
            this.update();
        }

        public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
        }
    }
}

