/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.search.PyProjectScopeBuilder;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyModuleNameIndex;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PyGotoSymbolContributor
implements GotoClassContributor {
    @NotNull
    public String[] getNames(Project project, boolean includeNonProjectItems) {
        HashSet<String> symbols = new HashSet<String>();
        symbols.addAll(PyClassNameIndex.allKeys(project));
        symbols.addAll(PyModuleNameIndex.getAllKeys(project));
        symbols.addAll(StubIndex.getInstance().getAllKeys(PyFunctionNameIndex.KEY, project));
        symbols.addAll(StubIndex.getInstance().getAllKeys(PyVariableNameIndex.KEY, project));
        String[] stringArray = ArrayUtil.toStringArray(symbols);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PyGotoSymbolContributor", "getNames"));
        }
        return stringArray;
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? PyProjectScopeBuilder.excludeSdkTestsScope(project) : GlobalSearchScope.projectScope((Project)project);
        ArrayList<PyDocStringOwner> symbols = new ArrayList<PyDocStringOwner>();
        symbols.addAll(PyClassNameIndex.find(name, project, scope));
        symbols.addAll(PyModuleNameIndex.find(name, project, includeNonProjectItems));
        symbols.addAll(PyFunctionNameIndex.find(name, project, scope));
        symbols.addAll(PyVariableNameIndex.find(name, project, scope));
        NavigationItem[] navigationItemArray = symbols.toArray(new NavigationItem[symbols.size()]);
        if (navigationItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PyGotoSymbolContributor", "getItemsByName"));
        }
        return navigationItemArray;
    }

    public String getQualifiedName(NavigationItem item) {
        if (item instanceof PyQualifiedNameOwner) {
            return ((PyQualifiedNameOwner)item).getQualifiedName();
        }
        return null;
    }

    public String getQualifiedNameSeparator() {
        return ".";
    }
}

