/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformIcons;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PyDirectoryIconProvider
extends IconProvider {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        PsiDirectory directory;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/PyDirectoryIconProvider", "getIcon"));
        }
        if (element instanceof PsiDirectory && !PyDirectoryIconProvider.isSpecialDirectory(directory = (PsiDirectory)element) && PyDirectoryIconProvider.isImportablePackage(directory)) {
            return PlatformIcons.PACKAGE_ICON;
        }
        return null;
    }

    private static boolean isSpecialDirectory(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/jetbrains/python/PyDirectoryIconProvider", "isSpecialDirectory"));
        }
        VirtualFile vFile = directory.getVirtualFile();
        if (FileIndexFacade.getInstance((Project)directory.getProject()).isExcludedFile(vFile)) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        return module == null || PyUtil.getSourceRoots(module).contains(vFile);
    }

    private static boolean isImportablePackage(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/jetbrains/python/PyDirectoryIconProvider", "isImportablePackage"));
        }
        Collection<VirtualFile> sourceRoots = PyUtil.getSourceRoots((PsiElement)directory);
        for (PsiDirectory dir = directory; dir != null; dir = dir.getParentDirectory()) {
            if (sourceRoots.contains(dir.getVirtualFile())) {
                return true;
            }
            if (PyNames.isIdentifier(dir.getName()) && PyUtil.isPackage(dir, false, null)) continue;
            return false;
        }
        return false;
    }
}

