/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCustomType
implements PyClassLikeType {
    @NotNull
    private final List<PyClassLikeType> myTypesToMimic;
    @Nullable
    private final Processor<PyElement> myFilter;
    private final boolean myInstanceType;

    public PyCustomType(@Nullable Processor<PyElement> filter, boolean instanceType, PyClassLikeType ... typesToMimic) {
        if (typesToMimic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typesToMimic", "com/jetbrains/python/PyCustomType", "<init>"));
        }
        this.myTypesToMimic = new ArrayList<PyClassLikeType>();
        Preconditions.checkArgument((typesToMimic.length > 0 ? 1 : 0) != 0, (Object)"Provide at least one class");
        this.myFilter = filter;
        this.myTypesToMimic.addAll(Collections2.filter(Arrays.asList(typesToMimic), NotNullPredicate.INSTANCE));
        this.myInstanceType = instanceType;
    }

    @NotNull
    public final List<PyClassLikeType> getTypesToMimic() {
        List<PyClassLikeType> list = Collections.unmodifiableList(this.myTypesToMimic);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PyCustomType", "getTypesToMimic"));
        }
        return list;
    }

    @Override
    public final boolean isDefinition() {
        return !this.myInstanceType;
    }

    @Override
    public final PyClassLikeType toInstance() {
        return this.myInstanceType ? this : new PyCustomType(this.myFilter, true, this.myTypesToMimic.toArray(new PyClassLikeType[this.myTypesToMimic.size()]));
    }

    @Override
    @Nullable
    public final String getClassQName() {
        return null;
    }

    @Override
    @NotNull
    public final List<PyClassLikeType> getSuperClassTypes(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/PyCustomType", "getSuperClassTypes"));
        }
        List<PyClassLikeType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PyCustomType", "getSuperClassTypes"));
        }
        return list;
    }

    @Override
    @Nullable
    public final List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext, boolean inherited) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/PyCustomType", "resolveMember"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/PyCustomType", "resolveMember"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/PyCustomType", "resolveMember"));
        }
        ArrayList globalResult = new ArrayList();
        for (PyClassLikeType typeToMimic : this.myTypesToMimic) {
            List<? extends RatedResolveResult> results = typeToMimic.resolveMember(name, location, direction, resolveContext, inherited);
            if (results == null) continue;
            globalResult.addAll(Collections2.filter(results, (Predicate)new ResolveFilter()));
        }
        return globalResult;
    }

    @Override
    public final boolean isValid() {
        for (PyClassLikeType type : this.myTypesToMimic) {
            if (type.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public final PyClassLikeType getMetaClassType(@NotNull TypeEvalContext context, boolean inherited) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/PyCustomType", "getMetaClassType"));
        }
        return null;
    }

    @Override
    public final boolean isCallable() {
        if (!this.myInstanceType) {
            return true;
        }
        for (PyClassLikeType typeToMimic : this.myTypesToMimic) {
            if (!typeToMimic.isCallable()) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public final PyType getReturnType(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/PyCustomType", "getReturnType"));
        }
        return this.myInstanceType ? null : this.toInstance();
    }

    @Override
    @Nullable
    public final PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/PyCustomType", "getCallType"));
        }
        if (callSite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSite", "com/jetbrains/python/PyCustomType", "getCallType"));
        }
        return this.getReturnType(context);
    }

    @Override
    @Nullable
    public final List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/PyCustomType", "getParameters"));
        }
        return null;
    }

    @Override
    @Nullable
    public final List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/PyCustomType", "resolveMember"));
        }
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/jetbrains/python/PyCustomType", "resolveMember"));
        }
        if (resolveContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveContext", "com/jetbrains/python/PyCustomType", "resolveMember"));
        }
        return this.resolveMember(name, location, direction, resolveContext, true);
    }

    @Override
    public final Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        ArrayList lookupElements = new ArrayList();
        for (PyClassLikeType parentType : this.myTypesToMimic) {
            lookupElements.addAll(Collections2.filter(Arrays.asList(parentType.getCompletionVariants(completionPrefix, location, context)), (Predicate)new CompletionFilter()));
        }
        return lookupElements.toArray(new Object[lookupElements.size()]);
    }

    @Override
    @Nullable
    public final String getName() {
        ArrayList<String> classNames = new ArrayList<String>(this.myTypesToMimic.size());
        for (PyClassLikeType type : this.myTypesToMimic) {
            String name = type.getName();
            if (name == null && type instanceof PyClassType) {
                name = ((PyClassType)type).getPyClass().getName();
            }
            if (name == null) continue;
            classNames.add(name);
        }
        return PyBundle.message("custom.type.mimic.name", StringUtil.join(classNames, (String)","));
    }

    @Override
    public final boolean isBuiltin() {
        return false;
    }

    @Override
    public final void assertValid(String message) {
        for (PyClassLikeType type : this.myTypesToMimic) {
            type.assertValid(message);
        }
    }

    private class CompletionFilter
    implements Predicate<Object> {
        private CompletionFilter() {
        }

        public final boolean apply(@Nullable Object input) {
            if (input == null) {
                return false;
            }
            if (PyCustomType.this.myFilter == null) {
                return true;
            }
            if (!(input instanceof LookupElement)) {
                return true;
            }
            PyElement pyElement = PyUtil.as(((LookupElement)input).getPsiElement(), PyElement.class);
            if (pyElement == null) {
                return false;
            }
            return PyCustomType.this.myFilter.process((Object)pyElement);
        }
    }

    private class ResolveFilter
    implements Predicate<RatedResolveResult> {
        private ResolveFilter() {
        }

        public final boolean apply(@Nullable RatedResolveResult input) {
            if (input == null) {
                return false;
            }
            if (PyCustomType.this.myFilter == null) {
                return true;
            }
            PyElement pyElement = PyUtil.as(input.getElement(), PyElement.class);
            if (pyElement == null) {
                return false;
            }
            return PyCustomType.this.myFilter.process((Object)pyElement);
        }
    }
}

