/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportStatementBase;
import org.jetbrains.annotations.NotNull;

public class PyAddImportFix
implements LocalQuickFix {
    @NotNull
    private final String myImportToAdd;
    @NotNull
    private final PyFile myFile;

    public PyAddImportFix(@NotNull String importToAdd, @NotNull PyFile file) {
        if (importToAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importToAdd", "com/jetbrains/python/PyAddImportFix", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/PyAddImportFix", "<init>"));
        }
        this.myImportToAdd = importToAdd;
        this.myFile = file;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.add.import", this.myImportToAdd);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PyAddImportFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/PyAddImportFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/PyAddImportFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/PyAddImportFix", "applyFix"));
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(project);
        PyImportStatementBase statement = generator.createFromText(LanguageLevel.forElement(this.myFile), PyImportStatementBase.class, this.myImportToAdd);
        PsiElement recommendedPosition = AddImportHelper.getFileInsertPosition(this.myFile);
        this.myFile.addAfter((PsiElement)statement, recommendedPosition);
    }
}

