/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyqt;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.INativeFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.jetbrains.python.psi.resolve.QualifiedNameResolver;
import com.jetbrains.python.psi.resolve.QualifiedNameResolverImpl;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QtFileType
implements FileType,
INativeFileType {
    private final String myName;
    private final String myDescription;
    private final String myDefaultExtension;
    private final Icon myIcon;

    protected QtFileType(String name, String description, String defaultExtension, Icon icon) {
        this.myName = name;
        this.myDescription = description;
        this.myDefaultExtension = defaultExtension;
        this.myIcon = icon;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/pyqt/QtFileType", "getName"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/pyqt/QtFileType", "getDescription"));
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        String string = this.myDefaultExtension;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/pyqt/QtFileType", "getDefaultExtension"));
        }
        return string;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean isBinary() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/pyqt/QtFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/pyqt/QtFileType", "getCharset"));
        }
        return null;
    }

    public boolean openFileInAssociatedApplication(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/pyqt/QtFileType", "openFileInAssociatedApplication"));
        }
        String qtTool = QtFileType.findQtTool(ModuleUtil.findModuleForFile((VirtualFile)file, (Project)project), this.getToolName());
        if (qtTool == null) {
            return false;
        }
        try {
            Runtime.getRuntime().exec(new String[]{qtTool, file.getPath()});
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)("Failed to run Qt Designer: " + e.getMessage()), (String)"Error");
        }
        return true;
    }

    public static String findQtTool(Module module, String toolName) {
        if (SystemInfo.isWindows) {
            if (module == null) {
                return null;
            }
            Sdk sdk = PythonSdkType.findPythonSdk(module);
            if (sdk == null) {
                return null;
            }
            String tool = QtFileType.findToolInPackage(toolName, module, sdk, "PyQt4");
            if (tool != null) {
                return tool;
            }
            return QtFileType.findToolInPackage(toolName, module, sdk, "PySide");
        }
        return null;
    }

    @Nullable
    private static String findToolInPackage(String toolName, Module module, Sdk sdk, String name) {
        QualifiedNameResolver visitor = new QualifiedNameResolverImpl(name).fromModule(module).withSdk(sdk);
        List<PsiDirectory> elements = visitor.resultsOfType(PsiDirectory.class);
        for (PsiDirectory directory : elements) {
            VirtualFile tool = directory.getVirtualFile().findChild(toolName + ".exe");
            if (tool == null) continue;
            return tool.getPath();
        }
        return null;
    }

    protected abstract String getToolName();
}

