/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyqt;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunContentExecutor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.pyqt.QtFileType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CompileQrcAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        assert (vFiles != null);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        String path = QtFileType.findQtTool(module, "pyrcc4");
        if (path == null) {
            path = QtFileType.findQtTool(module, "pyside-rcc");
        }
        if (path == null) {
            Messages.showErrorDialog((Project)project, (String)"Could not find pyrcc4 or pyside-rcc for selected Python interpreter", (String)"Compile .qrc file");
            return;
        }
        CompileQrcDialog dialog = new CompileQrcDialog(project, vFiles);
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return;
        }
        GeneralCommandLine cmdLine = new GeneralCommandLine();
        cmdLine.setPassParentEnvironment(true);
        cmdLine.setExePath(path);
        cmdLine.addParameters(new String[]{"-o", dialog.getOutputPath()});
        for (VirtualFile vFile : vFiles) {
            cmdLine.addParameter(vFile.getPath());
        }
        try {
            OSProcessHandler process = new OSProcessHandler(cmdLine.createProcess(), cmdLine.getCommandLineString());
            ProcessTerminatedListener.attach((ProcessHandler)process);
            new RunContentExecutor(project, (ProcessHandler)process).withTitle("Compile .qrc").run();
        }
        catch (ExecutionException ex) {
            Messages.showErrorDialog((Project)project, (String)("Error running " + path + ": " + ex.getMessage()), (String)"Compile .qrc file");
        }
    }

    public void update(AnActionEvent e) {
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        e.getPresentation().setVisible(module != null && CompileQrcAction.filesAreQrc(vFiles));
    }

    private static boolean filesAreQrc(VirtualFile[] vFiles) {
        if (vFiles == null || vFiles.length == 0) {
            return false;
        }
        for (VirtualFile vFile : vFiles) {
            if (FileUtilRt.extensionEquals((String)vFile.getName(), (String)"qrc")) continue;
            return false;
        }
        return true;
    }

    public static class CompileQrcDialog
    extends DialogWrapper {
        private JPanel myPanel;
        private TextFieldWithBrowseButton myOutputFileField;

        protected CompileQrcDialog(Project project, VirtualFile[] vFiles) {
            super(project);
            int n = vFiles.length;
            this.$$$setupUI$$$();
            if (n == 1) {
                this.setTitle("Compile " + vFiles[0].getName());
            } else {
                this.setTitle("Compile " + vFiles.length + " .qrc files");
            }
            this.myOutputFileField.addBrowseFolderListener("Select output path:", null, project, FileChooserDescriptorFactory.createSingleLocalFileDescriptor());
            this.init();
        }

        protected JComponent createCenterPanel() {
            return this.myPanel;
        }

        public String getOutputPath() {
            return this.myOutputFileField.getText();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myOutputFileField;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            jLabel.setText("Output file:");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myOutputFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(400, -1), null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }
    }
}

