/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.numpy.documentation;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.numpy.documentation.NumPyDocStringParameter;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPsiFacade;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumPyDocString {
    private static final Pattern LINE_SEPARATOR = Pattern.compile("\n|\r|\r\n");
    private static final Pattern WHITE_SPACED_LINE = Pattern.compile("^[ \t]+$");
    private static final Pattern ANY_INDENT = Pattern.compile("(^[ \t]*)[^ \t\r\n]");
    private static final Pattern HAS_INDENT = Pattern.compile("(^[ \t]+)[^ \t\r\n]");
    private static final Pattern SIGNATURE = Pattern.compile("^([\\w., ]+=)?\\s*[\\w\\.]+\\(.*\\)$");
    private static final Pattern SECTION_HEADER = Pattern.compile("^[-=]+");
    private static final Pattern PARAMETER_WITH_TYPE = Pattern.compile("^(.+) : (.+)$");
    private static final Pattern PARAMETER_WITHOUT_TYPE = Pattern.compile("^([^ :,]+)$");
    private static final Pattern REDIRECT = Pattern.compile("^Refer to `(.*)` for full documentation.$");
    private static final Pattern NUMPY_UNION_PATTERN = Pattern.compile("^\\{(.*)\\}$");
    private static final Pattern QUOTED_STRING_PATTERN = Pattern.compile("^(?:\\\"(.*)\\\")|(?:\\'(.*)\\')$");
    private final String mySignature;
    private final List<NumPyDocStringParameter> myParameters;
    private final List<NumPyDocStringParameter> myReturns;

    private NumPyDocString(@Nullable String signature, @NotNull List<String> lines) throws NotNumpyDocStringException {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/numpy/documentation/NumPyDocString", "<init>"));
        }
        this.myParameters = new ArrayList<NumPyDocStringParameter>();
        this.myReturns = new ArrayList<NumPyDocStringParameter>();
        this.mySignature = signature;
        this.parseSections(lines);
        if (this.myReturns.size() == 0 && this.myParameters.size() == 0) {
            throw new NotNumpyDocStringException(signature);
        }
    }

    @Nullable
    public String getSignature() {
        return this.mySignature;
    }

    @NotNull
    public List<NumPyDocStringParameter> getParameters() {
        List<NumPyDocStringParameter> list = this.myParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/numpy/documentation/NumPyDocString", "getParameters"));
        }
        return list;
    }

    @NotNull
    public List<NumPyDocStringParameter> getReturns() {
        List<NumPyDocStringParameter> list = this.myReturns;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/numpy/documentation/NumPyDocString", "getReturns"));
        }
        return list;
    }

    @Nullable
    public NumPyDocStringParameter getNamedParameter(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/numpy/documentation/NumPyDocString", "getNamedParameter"));
        }
        for (NumPyDocStringParameter parameter : this.getParameters()) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }

    @Nullable
    private static PyFunction resolveRedirectToFunction(@NotNull String redirect, @NotNull PsiElement reference) {
        if (redirect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redirect", "com/jetbrains/numpy/documentation/NumPyDocString", "resolveRedirectToFunction"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/numpy/documentation/NumPyDocString", "resolveRedirectToFunction"));
        }
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)redirect);
        String functionName = qualifiedName.getLastComponent();
        PyPsiFacade facade = PyPsiFacade.getInstance(reference.getProject());
        List<PsiElement> items = facade.qualifiedNameResolver(qualifiedName.removeLastComponent()).fromElement(reference).resultsAsList();
        for (PsiElement item : items) {
            PsiElement element;
            if (item instanceof PsiDirectory) {
                item = ((PsiDirectory)item).findFile("__init__.py");
            }
            if (!(item instanceof PyFile) || !((element = ((PyFile)item).getElementNamed(functionName)) instanceof PyFunction)) continue;
            return (PyFunction)element;
        }
        return null;
    }

    @Nullable
    private static NumPyDocString forFunction(@NotNull PyFunction function, @Nullable PsiElement reference, @Nullable String knownSignature) {
        PyClass cls;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/numpy/documentation/NumPyDocString", "forFunction"));
        }
        String docString = function.getDocStringValue();
        if (docString == null && "__init__".equals(function.getName()) && (cls = function.getContainingClass()) != null) {
            docString = cls.getDocStringValue();
        }
        if (docString != null) {
            PyFunction resolvedFunction;
            String redirect;
            List<String> lines = NumPyDocString.splitByLines(docString);
            NumPyDocString.dedent(lines);
            String signature = null;
            if (!lines.isEmpty() && SIGNATURE.matcher(lines.get(0)).matches()) {
                signature = lines.get(0);
                lines.remove(0);
                NumPyDocString.dedent(lines);
            }
            if ((redirect = NumPyDocString.findRedirect(lines)) != null && reference != null && (resolvedFunction = NumPyDocString.resolveRedirectToFunction(redirect, reference)) != null) {
                return NumPyDocString.forFunction(resolvedFunction, reference, knownSignature != null ? knownSignature : signature);
            }
            try {
                return new NumPyDocString(knownSignature != null ? knownSignature : signature, lines);
            }
            catch (NotNumpyDocStringException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static NumPyDocString forFunction(@NotNull PyFunction function, @Nullable PsiElement reference) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/numpy/documentation/NumPyDocString", "forFunction"));
        }
        return NumPyDocString.forFunction(function, reference, null);
    }

    @NotNull
    private static List<String> splitByLines(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/numpy/documentation/NumPyDocString", "splitByLines"));
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : LINE_SEPARATOR.split(text)) {
            if (line.isEmpty() || WHITE_SPACED_LINE.matcher(line).matches()) continue;
            lines.add(line);
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/numpy/documentation/NumPyDocString", "splitByLines"));
        }
        return arrayList;
    }

    private static void dedent(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/numpy/documentation/NumPyDocString", "dedent"));
        }
        String margin = null;
        for (String line : lines) {
            Matcher matcher = ANY_INDENT.matcher(line);
            if (!matcher.find() || matcher.groupCount() == 0) continue;
            String indent = matcher.group(1);
            if (margin == null || margin.startsWith(indent) && margin.length() != indent.length()) {
                margin = indent;
                continue;
            }
            if (indent.startsWith(margin)) continue;
            margin = "";
            break;
        }
        if (margin != null && !margin.isEmpty()) {
            for (int i = 0; i < lines.size(); ++i) {
                lines.set(i, lines.get(i).substring(margin.length()));
            }
        }
    }

    private static int indexOfMatch(@NotNull List<String> lines, @NotNull Pattern pattern, int start) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/numpy/documentation/NumPyDocString", "indexOfMatch"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/numpy/documentation/NumPyDocString", "indexOfMatch"));
        }
        for (int i = start; i < lines.size(); ++i) {
            if (!pattern.matcher(lines.get(i)).matches()) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private static <T> List<T> copyOfRange(@NotNull List<T> src, int start, int end) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/jetbrains/numpy/documentation/NumPyDocString", "copyOfRange"));
        }
        ArrayList<T> dest = new ArrayList<T>();
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = src.size();
        }
        for (int i = start; i < end; ++i) {
            dest.add(src.get(i));
        }
        ArrayList<T> arrayList = dest;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/numpy/documentation/NumPyDocString", "copyOfRange"));
        }
        return arrayList;
    }

    @Nullable
    private static String findRedirect(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/numpy/documentation/NumPyDocString", "findRedirect"));
        }
        for (String line : lines) {
            Matcher matcher = REDIRECT.matcher(line);
            if (!matcher.matches() || matcher.groupCount() <= 0) continue;
            return matcher.group(1);
        }
        return null;
    }

    private void parseSections(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/numpy/documentation/NumPyDocString", "parseSections"));
        }
        int current = NumPyDocString.indexOfMatch(lines, SECTION_HEADER, 1);
        while (current != -1) {
            int next = NumPyDocString.indexOfMatch(lines, SECTION_HEADER, current + 1);
            String sectionName = lines.get(current - 1);
            if ("Parameters".equalsIgnoreCase(sectionName)) {
                NumPyDocString.parseParametersSection(NumPyDocString.copyOfRange(lines, current + 1, next - 1), this.myParameters);
            } else if ("Returns".equalsIgnoreCase(sectionName)) {
                NumPyDocString.parseParametersSection(NumPyDocString.copyOfRange(lines, current + 1, next - 1), this.myReturns);
            }
            current = next;
        }
    }

    private static void parseParametersSection(@NotNull List<String> lines, List<NumPyDocStringParameter> parameters) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/numpy/documentation/NumPyDocString", "parseParametersSection"));
        }
        DocStringParameterBuilder builder = null;
        for (String line : lines) {
            if (!HAS_INDENT.matcher(line).find()) {
                if (builder != null) {
                    parameters.add(builder.build());
                }
                builder = new DocStringParameterBuilder();
                Matcher parameterWithTypeMatcher = PARAMETER_WITH_TYPE.matcher(line);
                if (parameterWithTypeMatcher.matches()) {
                    builder.setName(parameterWithTypeMatcher.group(1));
                    builder.setType(parameterWithTypeMatcher.group(2));
                    continue;
                }
                Matcher parameterWithoutTypeMatcher = PARAMETER_WITHOUT_TYPE.matcher(line);
                if (!parameterWithoutTypeMatcher.matches()) continue;
                builder.setName(parameterWithoutTypeMatcher.group(1));
                builder.setType("object");
                continue;
            }
            if (builder == null) continue;
            builder.appendDescription(line.trim());
        }
        if (builder != null) {
            parameters.add(builder.build());
        }
    }

    @NotNull
    public static String cleanupOptional(@NotNull String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/jetbrains/numpy/documentation/NumPyDocString", "cleanupOptional"));
        }
        int index = typeString.indexOf(", optional");
        if (index >= 0) {
            String string = typeString.substring(0, index);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/numpy/documentation/NumPyDocString", "cleanupOptional"));
            }
            return string;
        }
        String string = typeString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/numpy/documentation/NumPyDocString", "cleanupOptional"));
        }
        return string;
    }

    @NotNull
    public static List<String> getNumpyUnionType(@NotNull String typeString) {
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/jetbrains/numpy/documentation/NumPyDocString", "getNumpyUnionType"));
        }
        Matcher matcher = NUMPY_UNION_PATTERN.matcher(typeString);
        if (matcher.matches()) {
            typeString = matcher.group(1);
        }
        List<String> list = Arrays.asList(typeString.split(" *, *"));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/numpy/documentation/NumPyDocString", "getNumpyUnionType"));
        }
        return list;
    }

    @NotNull
    public static Set<String> extractPermissibleArgumentsFromNumpyDocType(String typeString) {
        List<String> elements = NumPyDocString.getNumpyUnionType(NumPyDocString.cleanupOptional(typeString));
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String element : elements) {
            Matcher matcher = QUOTED_STRING_PATTERN.matcher(element);
            if (!matcher.matches()) continue;
            if (matcher.group(1) != null) {
                result.add(matcher.group(1));
                continue;
            }
            if (matcher.group(2) == null) continue;
            result.add(matcher.group(2));
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/numpy/documentation/NumPyDocString", "extractPermissibleArgumentsFromNumpyDocType"));
        }
        return linkedHashSet;
    }

    public static class DocStringParameterBuilder {
        private String myName = "";
        private String myType = "";
        private StringBuilder myDescription = new StringBuilder();

        public void setName(String name) {
            this.myName = name;
        }

        public void setType(String type) {
            this.myType = type;
        }

        public void appendDescription(String text) {
            this.myDescription.append(" ");
            this.myDescription.append(text);
        }

        public NumPyDocStringParameter build() {
            return new NumPyDocStringParameter(this.myName, this.myType, this.myDescription.toString());
        }
    }

    public static class NotNumpyDocStringException
    extends Exception {
        public NotNumpyDocStringException(String signature) {
            super("Function " + signature + " is not containing docstring of Numpy format.");
        }
    }
}

