/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.numpy.codeInsight;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.numpy.documentation.NumPyDocString;
import com.jetbrains.numpy.documentation.NumPyDocStringParameter;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeProviderBase;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumpyDocStringTypeProvider
extends PyTypeProviderBase {
    private static final Map<String, String> NUMPY_ALIAS_TO_REAL_TYPE = new HashMap<String, String>();

    @Override
    @Nullable
    public PyType getCallType(@NotNull PyFunction function, @Nullable PyCallSiteExpression callSite, @NotNull TypeEvalContext context) {
        PyExpression callee;
        NumPyDocString docString;
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "getCallType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "getCallType"));
        }
        if (NumpyDocStringTypeProvider.isInsideNumPy(function) && (docString = NumPyDocString.forFunction(function, (PsiElement)(callee = callSite instanceof PyCallExpression ? ((PyCallExpression)callSite).getCallee() : null))) != null) {
            List<NumPyDocStringParameter> returns = docString.getReturns();
            PyPsiFacade facade = NumpyDocStringTypeProvider.getPsiFacade(function);
            switch (returns.size()) {
                case 0: {
                    return facade.parseTypeAnnotation("None", function);
                }
                case 1: {
                    String typeName = returns.get(0).getType();
                    if (typeName != null) {
                        return NumpyDocStringTypeProvider.parseNumpyDocType(function, typeName);
                    }
                    return null;
                }
            }
            ArrayList<PyType> members = new ArrayList<PyType>();
            for (NumPyDocStringParameter ret : returns) {
                String memberTypeName = ret.getType();
                members.add(memberTypeName != null ? NumpyDocStringTypeProvider.parseNumpyDocType(function, memberTypeName) : null);
            }
            return facade.createTupleType(members, function);
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getParameterType(@NotNull PyNamedParameter parameter, @NotNull PyFunction function, @NotNull TypeEvalContext context) {
        String name;
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "getParameterType"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "getParameterType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "getParameterType"));
        }
        if (NumpyDocStringTypeProvider.isInsideNumPy(function) && (name = parameter.getName()) != null) {
            return this.getParameterType(function, name);
        }
        return null;
    }

    private static boolean isInsideNumPy(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "isInsideNumPy"));
        }
        PsiFile file = element.getContainingFile();
        if (file != null) {
            PyPsiFacade facade = NumpyDocStringTypeProvider.getPsiFacade(element);
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                String name = facade.findShortestImportableName(virtualFile, element);
                return name != null && name.startsWith("numpy.");
            }
        }
        return false;
    }

    private static PyPsiFacade getPsiFacade(@NotNull PsiElement anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "getPsiFacade"));
        }
        return PyPsiFacade.getInstance(anchor.getProject());
    }

    @Nullable
    private static PyType parseSingleNumpyDocType(@NotNull PsiElement anchor, @NotNull String typeString) {
        PyType type;
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "parseSingleNumpyDocType"));
        }
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "parseSingleNumpyDocType"));
        }
        PyPsiFacade facade = NumpyDocStringTypeProvider.getPsiFacade(anchor);
        String realTypeName = NUMPY_ALIAS_TO_REAL_TYPE.get(typeString);
        if (realTypeName != null && (type = facade.parseTypeAnnotation(realTypeName, anchor)) != null) {
            return type;
        }
        return facade.parseTypeAnnotation(typeString, anchor);
    }

    @Nullable
    private static PyType parseNumpyDocType(@NotNull PsiElement anchor, @NotNull String typeString) {
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "parseNumpyDocType"));
        }
        if (typeString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "parseNumpyDocType"));
        }
        typeString = NumPyDocString.cleanupOptional(typeString);
        LinkedHashSet<PyType> types = new LinkedHashSet<PyType>();
        for (String typeName : NumPyDocString.getNumpyUnionType(typeString)) {
            PyType parsedType = NumpyDocStringTypeProvider.parseSingleNumpyDocType(anchor, typeName);
            if (parsedType == null) continue;
            types.add(parsedType);
        }
        return NumpyDocStringTypeProvider.getPsiFacade(anchor).createUnionType(types);
    }

    @Nullable
    private PyType getParameterType(@NotNull PyFunction function, @NotNull String parameterName) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "getParameterType"));
        }
        if (parameterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterName", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "getParameterType"));
        }
        NumPyDocString docString = NumPyDocString.forFunction(function, function);
        if (docString != null) {
            NumPyDocStringParameter parameter = docString.getNamedParameter(parameterName);
            if (parameter == null && parameterName.startsWith("p_")) {
                parameter = docString.getNamedParameter(parameterName.substring(2));
            }
            if (parameter != null) {
                return NumpyDocStringTypeProvider.parseNumpyDocType(function, parameter.getType());
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PyType getReturnType(@NotNull Callable callable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "getReturnType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/numpy/codeInsight/NumpyDocStringTypeProvider", "getReturnType"));
        }
        if (callable instanceof PyFunction) {
            return this.getCallType((PyFunction)callable, null, context);
        }
        return null;
    }

    static {
        NUMPY_ALIAS_TO_REAL_TYPE.put("ndarray", "numpy.core.multiarray.ndarray");
        NUMPY_ALIAS_TO_REAL_TYPE.put("array_like", "collections.Iterable or int or long or float or complex");
        NUMPY_ALIAS_TO_REAL_TYPE.put("data-type", "object");
        NUMPY_ALIAS_TO_REAL_TYPE.put("scalar", "int or long or float or complex");
        NUMPY_ALIAS_TO_REAL_TYPE.put("array", "collections.Iterable");
        NUMPY_ALIAS_TO_REAL_TYPE.put("any", "object");
        NUMPY_ALIAS_TO_REAL_TYPE.put("Standard Python scalar object", "int or long or float or complex");
        NUMPY_ALIAS_TO_REAL_TYPE.put("Python type", "object");
        NUMPY_ALIAS_TO_REAL_TYPE.put("callable", "collections.Callable");
        NUMPY_ALIAS_TO_REAL_TYPE.put("number", "int or long or float or complex");
    }
}

