/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.WatchInplaceEditor;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchMessageNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchesRootNode
extends XDebuggerTreeNode {
    private final XWatchesView myWatchesView;
    private List<WatchNode> myChildren;
    private List<XDebuggerTreeNode> myLoadedChildren;
    private XDebuggerEvaluator myCurrentEvaluator;

    public WatchesRootNode(@NotNull XDebuggerTree tree, @NotNull XWatchesView watchesView, @NotNull XExpression[] watchExpressions) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "<init>"));
        }
        if (watchesView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "watchesView", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "<init>"));
        }
        if (watchExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "watchExpressions", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "<init>"));
        }
        super(tree, null, false);
        this.myWatchesView = watchesView;
        this.myChildren = new ArrayList<WatchNode>();
        for (XExpression watchExpression : watchExpressions) {
            this.myChildren.add(WatchMessageNode.createMessageNode(tree, this, watchExpression));
        }
    }

    public void updateWatches(@Nullable XDebuggerEvaluator evaluator) {
        this.myCurrentEvaluator = evaluator;
        ArrayList<WatchNode> newChildren = new ArrayList<WatchNode>();
        if (evaluator != null) {
            for (WatchNode child : this.myChildren) {
                XExpression expression = child.getExpression();
                WatchMessageNode evaluatingNode = WatchMessageNode.createEvaluatingNode(this.myTree, this, expression);
                newChildren.add(evaluatingNode);
                evaluator.evaluate(expression, (XDebuggerEvaluator.XEvaluationCallback)new MyEvaluationCallback(evaluatingNode), null);
            }
        } else {
            for (WatchNode child : this.myChildren) {
                XExpression expression = child.getExpression();
                newChildren.add(WatchMessageNode.createMessageNode(this.myTree, this, expression));
            }
        }
        this.myChildren = newChildren;
        this.myLoadedChildren = null;
        this.fireNodeStructureChanged();
    }

    @Override
    @NotNull
    public List<? extends TreeNode> getChildren() {
        List<WatchNode> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "getChildren"));
        }
        return list;
    }

    @Nullable
    public List<? extends WatchNode> getAllChildren() {
        return this.myChildren;
    }

    @Override
    public List<? extends XDebuggerTreeNode> getLoadedChildren() {
        if (this.myLoadedChildren == null) {
            this.myLoadedChildren = new ArrayList<XDebuggerTreeNode>();
            for (WatchNode child : this.myChildren) {
                if (!(child instanceof WatchNodeImpl)) continue;
                this.myLoadedChildren.add((WatchNodeImpl)child);
            }
        }
        return this.myLoadedChildren;
    }

    @Override
    public void clearChildren() {
        this.updateWatches(this.myCurrentEvaluator);
    }

    private void replaceNode(WatchNode oldNode, WatchNode newNode) {
        int[] selectedRows = this.getTree().getSelectionRows();
        for (int i = 0; i < this.myChildren.size(); ++i) {
            WatchNode child = this.myChildren.get(i);
            if (child != oldNode) continue;
            this.myChildren.set(i, newNode);
            if (newNode instanceof XValueContainerNode) {
                this.myLoadedChildren = null;
                this.fireNodeStructureChanged(newNode);
                this.myTree.childrenLoaded(this, Collections.singletonList((XValueContainerNode)((Object)newNode)), false);
            } else {
                this.fireNodeStructureChanged(newNode);
            }
            this.getTree().setSelectionRows(selectedRows);
            return;
        }
    }

    public void addWatchExpression(@Nullable XDebuggerEvaluator evaluator, @NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        WatchMessageNode message;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode", "addWatchExpression"));
        }
        WatchMessageNode watchMessageNode = message = evaluator != null ? WatchMessageNode.createEvaluatingNode(this.myTree, this, expression) : WatchMessageNode.createMessageNode(this.myTree, this, expression);
        if (index == -1) {
            this.myChildren.add(message);
            index = this.myChildren.size() - 1;
        } else {
            this.myChildren.add(index, message);
        }
        this.fireNodeInserted(index);
        if (navigateToWatchNode) {
            this.myTree.scrollPathToVisible(message.getPath());
        }
        if (evaluator != null) {
            evaluator.evaluate(expression, (XDebuggerEvaluator.XEvaluationCallback)new MyEvaluationCallback(message), null);
        }
    }

    private void fireNodeInserted(int index) {
        this.myTree.getTreeModel().nodesWereInserted(this, new int[]{index});
    }

    public int removeChildNode(XDebuggerTreeNode node) {
        int index = this.myChildren.indexOf(node);
        if (index != -1) {
            this.myChildren.remove(node);
            this.myLoadedChildren = null;
            this.fireNodesRemoved(new int[]{index}, new TreeNode[]{node});
        }
        return index;
    }

    public void removeChildren(Collection<? extends XDebuggerTreeNode> nodes) {
        int[] indices = this.getNodesIndices(nodes);
        TreeNode[] removed = this.getChildNodes(indices);
        this.myChildren.removeAll(nodes);
        this.myLoadedChildren = null;
        this.fireNodesRemoved(indices, removed);
    }

    public void removeAllChildren() {
        this.myChildren.clear();
        this.myLoadedChildren = null;
        this.fireNodeStructureChanged();
    }

    public void addNewWatch() {
        this.editWatch(null);
    }

    public void editWatch(@Nullable WatchNode node) {
        int index;
        WatchMessageNode messageNode = WatchMessageNode.createMessageNode(this.myTree, this, XExpressionImpl.EMPTY_EXPRESSION);
        int n = index = node != null ? this.myChildren.indexOf(node) : -1;
        if (index == -1) {
            this.myChildren.add(messageNode);
            this.fireNodeInserted(this.myChildren.size() - 1);
        } else {
            this.myChildren.set(index, messageNode);
            this.fireNodeStructureChanged(messageNode);
        }
        XDebugSession session = XDebugView.getSession((Component)((Object)this.myTree));
        new WatchInplaceEditor(this, session, this.myWatchesView, messageNode, "watch", node).show();
    }

    private class MyEvaluationCallback
    extends XEvaluationCallbackBase {
        private final WatchNode myResultPlace;

        public MyEvaluationCallback(WatchNode resultPlace) {
            if (resultPlace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultPlace", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$MyEvaluationCallback", "<init>"));
            }
            this.myResultPlace = resultPlace;
        }

        public void evaluated(final @NotNull XValue result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$MyEvaluationCallback", "evaluated"));
            }
            DebuggerUIUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WatchesRootNode.this.replaceNode(MyEvaluationCallback.this.myResultPlace, new WatchNodeImpl(WatchesRootNode.this.myTree, WatchesRootNode.this, result, MyEvaluationCallback.this.myResultPlace.getExpression()));
                }
            });
        }

        public void errorOccurred(final @NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/ui/tree/nodes/WatchesRootNode$MyEvaluationCallback", "errorOccurred"));
            }
            DebuggerUIUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WatchesRootNode.this.replaceNode(MyEvaluationCallback.this.myResultPlace, WatchMessageNode.createErrorNode(WatchesRootNode.this.myTree, WatchesRootNode.this, MyEvaluationCallback.this.myResultPlace.getExpression(), errorMessage));
                }
            });
        }
    }
}

